/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.ImmutableParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexConstraint;

public class DefaultParameterStore
implements ParameterStore {
    private final Map<String, Parameter<?>> parameters = new LinkedHashMap();

    public DefaultParameterStore() {
        this.get("*", new ImmutableParameter((Parameter<?>)((Object)new DefaultParameter("*").constrainedBy((Constraint)new RegexConstraint(".*")))));
    }

    @Override
    public Parameter<?> get(String name, Parameter<?> deflt) {
        Parameter<?> parameter = null;
        if (this.parameters.get(name) != null) {
            parameter = this.parameters.get(name);
        } else {
            parameter = deflt;
            this.parameters.put(name, parameter);
        }
        if (parameter == null) {
            throw new IllegalArgumentException("No such parameter [" + name + "] exists.");
        }
        return parameter;
    }

    @Override
    public Parameter<?> get(String name) {
        if (!this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("No such parameter [" + name + "] exists.");
        }
        return this.parameters.get(name);
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Parameter<?> store(Parameter<?> value) {
        Assert.notNull(value, "Parameter to store must not be null.");
        return this.parameters.put(value.getName(), value);
    }

    @Override
    public int size() {
        return this.parameters.size() - 1;
    }

    @Override
    public Iterator<Map.Entry<String, Parameter<?>>> iterator() {
        return this.parameters.entrySet().iterator();
    }

    @Override
    public boolean contains(String name) {
        return this.parameters.containsKey(name);
    }

    public String toString() {
        return this.parameters.keySet().toString();
    }
}

