/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.xml.impl.xmlbeans;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;

public class LogicalEquality {
    public static boolean nodesEqual(XmlCursor xmlOne, XmlCursor xmlTwo) {
        boolean result = false;
        if (xmlOne.isStartdoc()) {
            xmlOne.toFirstContentToken();
        }
        if (xmlTwo.isStartdoc()) {
            xmlTwo.toFirstContentToken();
        }
        if (xmlOne.currentTokenType() == xmlTwo.currentTokenType()) {
            if (xmlOne.isEnddoc()) {
                result = true;
            } else if (xmlOne.isAttr()) {
                result = LogicalEquality.attributesEqual(xmlOne, xmlTwo);
            } else if (xmlOne.isText()) {
                result = LogicalEquality.textNodesEqual(xmlOne, xmlTwo);
            } else if (xmlOne.isComment()) {
                result = LogicalEquality.commentsEqual(xmlOne, xmlTwo);
            } else if (xmlOne.isProcinst()) {
                result = LogicalEquality.processingInstructionsEqual(xmlOne, xmlTwo);
            } else if (xmlOne.isStart()) {
                result = LogicalEquality.elementsEqual(xmlOne, xmlTwo);
            }
        }
        return result;
    }

    private static boolean elementsEqual(XmlCursor xmlOne, XmlCursor xmlTwo) {
        boolean result = true;
        if (!LogicalEquality.qnamesEqual(xmlOne.getName(), xmlTwo.getName())) {
            result = false;
        } else {
            LogicalEquality.nextToken(xmlOne);
            LogicalEquality.nextToken(xmlTwo);
            do {
                if (xmlOne.currentTokenType() != xmlTwo.currentTokenType()) {
                    result = false;
                    break;
                }
                if (xmlOne.isEnd() || xmlOne.isEnddoc()) break;
                if (xmlOne.isAttr()) {
                    result = LogicalEquality.attributeListsEqual(xmlOne, xmlTwo);
                    continue;
                }
                if (xmlOne.isText()) {
                    result = LogicalEquality.textNodesEqual(xmlOne, xmlTwo);
                } else if (xmlOne.isComment()) {
                    result = LogicalEquality.commentsEqual(xmlOne, xmlTwo);
                } else if (xmlOne.isProcinst()) {
                    result = LogicalEquality.processingInstructionsEqual(xmlOne, xmlTwo);
                } else if (xmlOne.isStart()) {
                    result = LogicalEquality.elementsEqual(xmlOne, xmlTwo);
                }
                LogicalEquality.nextToken(xmlOne);
                LogicalEquality.nextToken(xmlTwo);
            } while (result);
        }
        return result;
    }

    private static boolean attributeListsEqual(XmlCursor xmlOne, XmlCursor xmlTwo) {
        boolean result = true;
        TreeMap mapOne = LogicalEquality.loadAttributeMap(xmlOne);
        TreeMap mapTwo = LogicalEquality.loadAttributeMap(xmlTwo);
        if (mapOne.size() != mapTwo.size()) {
            result = false;
        } else {
            Set keysOne = mapOne.keySet();
            Set keysTwo = mapTwo.keySet();
            Iterator itOne = keysOne.iterator();
            Iterator itTwo = keysTwo.iterator();
            while (result && itOne.hasNext()) {
                QName qnameTwo;
                String valueTwo;
                String valueOne = (String)itOne.next();
                if (!valueOne.equals(valueTwo = (String)itTwo.next())) {
                    result = false;
                    continue;
                }
                QName qnameOne = (QName)mapOne.get(valueOne);
                if (LogicalEquality.qnamesEqual(qnameOne, qnameTwo = (QName)mapTwo.get(valueTwo))) continue;
                result = false;
            }
        }
        return result;
    }

    private static TreeMap loadAttributeMap(XmlCursor xml) {
        TreeMap<String, QName> result = new TreeMap<String, QName>();
        while (xml.isAttr()) {
            result.put(xml.getTextValue(), xml.getName());
            LogicalEquality.nextToken(xml);
        }
        return result;
    }

    private static boolean attributesEqual(XmlCursor xmlOne, XmlCursor xmlTwo) {
        boolean result = false;
        if (xmlOne.isAttr() && xmlTwo.isAttr() && LogicalEquality.qnamesEqual(xmlOne.getName(), xmlTwo.getName()) && xmlOne.getTextValue().equals(xmlTwo.getTextValue())) {
            result = true;
        }
        return result;
    }

    private static boolean textNodesEqual(XmlCursor xmlOne, XmlCursor xmlTwo) {
        boolean result = false;
        if (xmlOne.isText() && xmlTwo.isText() && xmlOne.getChars().equals(xmlTwo.getChars())) {
            result = true;
        }
        return result;
    }

    private static boolean commentsEqual(XmlCursor xmlOne, XmlCursor xmlTwo) {
        boolean result = false;
        if (xmlOne.isComment() && xmlTwo.isComment() && xmlOne.getTextValue().equals(xmlTwo.getTextValue())) {
            result = true;
        }
        return result;
    }

    private static boolean processingInstructionsEqual(XmlCursor xmlOne, XmlCursor xmlTwo) {
        boolean result = false;
        if (xmlOne.isProcinst() && xmlTwo.isProcinst() && LogicalEquality.qnamesEqual(xmlOne.getName(), xmlTwo.getName()) && xmlOne.getTextValue().equals(xmlTwo.getTextValue())) {
            result = true;
        }
        return result;
    }

    private static boolean qnamesEqual(QName qnameOne, QName qnameTwo) {
        boolean result = false;
        if (qnameOne.getNamespaceURI().equals(qnameTwo.getNamespaceURI()) && qnameOne.getLocalPart().equals(qnameTwo.getLocalPart())) {
            return true;
        }
        return result;
    }

    private static void nextToken(XmlCursor xml) {
        do {
            xml.toNextToken();
        } while (xml.isText() && xml.getChars().trim().length() <= 0);
    }
}

