/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind.tuckey.shade.utils;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.ocpsoft.rewrite.bind.tuckey.shade.utils.StringUtils;

public class Log {
    private static Log localLog = Log.getLog(class$org$tuckey$web$filters$urlrewrite$utils$Log == null ? (class$org$tuckey$web$filters$urlrewrite$utils$Log = Log.class$("org.ocpsoft.rewrite.bind.tuckey.shade.utils.Log")) : class$org$tuckey$web$filters$urlrewrite$utils$Log);
    private static ServletContext context = null;
    private static final String DEFAULT_LOG_LEVEL = "INFO";
    private static boolean usingSystemOut = false;
    private static boolean usingSystemErr = false;
    private static boolean usingLog4j = false;
    private static boolean usingCommonsLogging = false;
    private static boolean traceLevelEnabled = false;
    private static boolean debugLevelEnabled = false;
    private static boolean infoLevelEnabled = false;
    private static boolean warnLevelEnabled = false;
    private static boolean errorLevelEnabled = false;
    private static boolean fatalLevelEnabled = false;
    private Class clazz = null;
    private Logger log4jLogger = null;
    private org.apache.commons.logging.Log commonsLog = null;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$utils$Log;

    private Log(Class clazz) {
        this.clazz = clazz;
        this.isUsingLog4j();
        this.isUsingCommonsLogging();
    }

    private boolean isUsingLog4j() {
        if (usingLog4j && this.log4jLogger == null) {
            this.log4jLogger = Logger.getLogger((Class)this.clazz);
        }
        return usingLog4j;
    }

    public boolean isUsingCommonsLogging() {
        if (usingCommonsLogging && this.commonsLog == null) {
            this.commonsLog = LogFactory.getLog((Class)this.clazz);
        }
        return usingCommonsLogging;
    }

    public boolean isTraceEnabled() {
        if (this.isUsingLog4j()) {
            return this.log4jLogger.isEnabledFor(Priority.DEBUG);
        }
        if (this.isUsingCommonsLogging()) {
            return this.commonsLog.isTraceEnabled();
        }
        return traceLevelEnabled;
    }

    public boolean isDebugEnabled() {
        if (this.isUsingLog4j()) {
            return this.log4jLogger.isEnabledFor(Priority.DEBUG);
        }
        if (this.isUsingCommonsLogging()) {
            return this.commonsLog.isDebugEnabled();
        }
        return traceLevelEnabled || debugLevelEnabled;
    }

    public boolean isInfoEnabled() {
        if (this.isUsingLog4j()) {
            return this.log4jLogger.isEnabledFor(Priority.INFO);
        }
        if (this.isUsingCommonsLogging()) {
            return this.commonsLog.isInfoEnabled();
        }
        return traceLevelEnabled || debugLevelEnabled || infoLevelEnabled;
    }

    public boolean isWarnEnabled() {
        if (this.isUsingLog4j()) {
            return this.log4jLogger.isEnabledFor(Priority.WARN);
        }
        if (this.isUsingCommonsLogging()) {
            return this.commonsLog.isWarnEnabled();
        }
        return traceLevelEnabled || debugLevelEnabled || infoLevelEnabled || warnLevelEnabled;
    }

    public boolean isErrorEnabled() {
        if (this.isUsingLog4j()) {
            return this.log4jLogger.isEnabledFor(Priority.ERROR);
        }
        if (this.isUsingCommonsLogging()) {
            return this.commonsLog.isErrorEnabled();
        }
        return traceLevelEnabled || debugLevelEnabled || infoLevelEnabled || warnLevelEnabled || errorLevelEnabled;
    }

    public boolean isFatalEnabled() {
        if (this.isUsingLog4j()) {
            return this.log4jLogger.isEnabledFor(Priority.FATAL);
        }
        if (this.isUsingCommonsLogging()) {
            return this.commonsLog.isFatalEnabled();
        }
        return traceLevelEnabled || debugLevelEnabled || infoLevelEnabled || warnLevelEnabled || errorLevelEnabled || fatalLevelEnabled;
    }

    public void trace(Object o) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.debug(o);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.trace(o);
            return;
        }
        this.write("TRACE", o);
    }

    public void trace(Object o, Throwable throwable) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.debug(o, throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.trace(o, throwable);
            return;
        }
        this.write("TRACE", o, throwable);
    }

    public void trace(Throwable throwable) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.debug((Object)throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.trace((Object)throwable);
            return;
        }
        this.write("TRACE", throwable, throwable);
    }

    public void debug(Object o) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.debug(o);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.debug(o);
            return;
        }
        this.write("DEBUG", o);
    }

    public void debug(Object o, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.debug(o, throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.debug(o, throwable);
            return;
        }
        this.write("DEBUG", o, throwable);
    }

    public void debug(Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.debug((Object)throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.debug((Object)throwable);
            return;
        }
        this.write("DEBUG", throwable, throwable);
    }

    public void info(Object o) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.info(o);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.info(o);
            return;
        }
        this.write(DEFAULT_LOG_LEVEL, o);
    }

    public void info(Object o, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.info(o, throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.info(o, throwable);
            return;
        }
        this.write(DEFAULT_LOG_LEVEL, o, throwable);
    }

    public void info(Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.info((Object)throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.info((Object)throwable);
            return;
        }
        this.write(DEFAULT_LOG_LEVEL, throwable, throwable);
    }

    public void warn(Object o) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.warn(o);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.warn(o);
            return;
        }
        this.write("WARN", o);
    }

    public void warn(Object o, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.warn(o, throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.warn(o, throwable);
            return;
        }
        this.write("WARN", o, throwable);
    }

    public void warn(Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.warn((Object)throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.warn((Object)throwable);
            return;
        }
        this.write("WARN", throwable, throwable);
    }

    public void error(Object o) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.error(o);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.error(o);
            return;
        }
        this.write("ERROR", o);
    }

    public void error(Object o, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.error(o, throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.error(o, throwable);
            return;
        }
        this.write("ERROR", o, throwable);
    }

    public void error(Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.error((Object)throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.error((Object)throwable);
            return;
        }
        this.write("ERROR", throwable, throwable);
    }

    public void fatal(Object o) {
        if (!this.isFatalEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.fatal(o);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.fatal(o);
            return;
        }
        this.write("FATAL", o);
    }

    public void fatal(Object o, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.fatal(o, throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.fatal(o, throwable);
            return;
        }
        this.write("FATAL", o, throwable);
    }

    public void fatal(Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        if (this.isUsingLog4j()) {
            this.log4jLogger.fatal((Object)throwable);
            return;
        }
        if (this.isUsingCommonsLogging()) {
            this.commonsLog.fatal((Object)throwable);
            return;
        }
        this.write("FATAL", throwable, throwable);
    }

    public static Log getLog(Class aClass) {
        return new Log(aClass);
    }

    public static void setLevel(String level) {
        usingSystemOut = false;
        usingSystemErr = false;
        if ("LOG4J".equalsIgnoreCase(level)) {
            usingLog4j = true;
        } else if ("COMMONS".equalsIgnoreCase(level)) {
            usingCommonsLogging = true;
        } else {
            if (level != null) {
                if (level.startsWith("SYSOUT:")) {
                    usingSystemOut = true;
                    level = level.substring("SYSOUT:".length());
                }
                if (level.startsWith("STDOUT:")) {
                    usingSystemOut = true;
                    level = level.substring("STDOUT:".length());
                }
                if (level.startsWith("STDERR:")) {
                    usingSystemErr = true;
                    level = level.substring("STDERR:".length());
                }
                if (level.startsWith("SYSERR:")) {
                    usingSystemErr = true;
                    level = level.substring("SYSERR:".length());
                }
            }
            Log.setLevelInternal(level);
        }
    }

    private static void setLevelInternal(String level) {
        traceLevelEnabled = false;
        debugLevelEnabled = false;
        infoLevelEnabled = false;
        warnLevelEnabled = false;
        errorLevelEnabled = false;
        fatalLevelEnabled = false;
        boolean levelSelected = false;
        if ("TRACE".equalsIgnoreCase(level)) {
            traceLevelEnabled = true;
            levelSelected = true;
        }
        if ("DEBUG".equalsIgnoreCase(level)) {
            debugLevelEnabled = true;
            levelSelected = true;
        }
        if (DEFAULT_LOG_LEVEL.equalsIgnoreCase(level)) {
            infoLevelEnabled = true;
            levelSelected = true;
        }
        if ("WARN".equalsIgnoreCase(level)) {
            warnLevelEnabled = true;
            levelSelected = true;
        }
        if ("ERROR".equalsIgnoreCase(level)) {
            errorLevelEnabled = true;
            levelSelected = true;
        }
        if ("FATAL".equalsIgnoreCase(level)) {
            fatalLevelEnabled = true;
            levelSelected = true;
        }
        if (!levelSelected) {
            infoLevelEnabled = true;
        }
    }

    private void write(String level, Object o, Throwable throwable) {
        String msg = this.getMsg(level, o).toString();
        if (usingSystemOut || context == null) {
            System.out.println(msg);
            throwable.printStackTrace(System.out);
        } else if (usingSystemErr) {
            System.err.println(msg);
            throwable.printStackTrace(System.err);
        } else {
            context.log(msg, throwable);
        }
    }

    private void write(String level, Object o) {
        String msg = this.getMsg(level, o).toString();
        if (usingSystemOut || context == null) {
            System.out.println(msg);
        } else if (usingSystemErr) {
            System.err.println(msg);
        } else {
            context.log(msg);
        }
    }

    private StringBuffer getMsg(String level, Object o) {
        StringBuffer msg = new StringBuffer();
        if (this.clazz == null) {
            msg.append("null");
        } else {
            msg.append(this.clazz.getName());
        }
        msg.append(" ");
        msg.append(level);
        msg.append(": ");
        msg.append(o.toString());
        return msg;
    }

    public static void resetAll() {
        context = null;
        Log.setLevel(DEFAULT_LOG_LEVEL);
        usingSystemOut = false;
        usingSystemErr = false;
        usingLog4j = false;
        usingCommonsLogging = false;
    }

    public static void setConfiguration(FilterConfig filterConfig) {
        Log.resetAll();
        if (filterConfig == null) {
            localLog.error("no filter config passed");
            return;
        }
        context = filterConfig.getServletContext();
        String logLevelConf = filterConfig.getInitParameter("logLevel");
        if (logLevelConf != null) {
            logLevelConf = StringUtils.trim(logLevelConf);
        }
        Log.setLevel(logLevelConf);
        localLog.debug("logLevel set to " + logLevelConf);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

