/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.config.CompositeCondition;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.DefaultConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public final class And
extends DefaultConditionBuilder
implements CompositeCondition {
    private final Condition[] conditions;

    private And(Condition ... conditions) {
        this.conditions = conditions;
    }

    public static And all(Condition ... conditions) {
        Assert.notNull(conditions, "At least one condition is required.");
        Assert.assertTrue(conditions.length > 0, "At least one condition is required.");
        return new And(And.flattenConditions(Arrays.asList(conditions)).toArray(new Condition[0]));
    }

    private static List<Condition> flattenConditions(List<Condition> conditions) {
        ArrayList<Condition> result = new ArrayList<Condition>();
        for (Condition condition : conditions) {
            if (condition instanceof And) {
                result.addAll(And.flattenConditions(((And)condition).getConditions()));
                continue;
            }
            result.add(condition);
        }
        return result;
    }

    @Override
    public boolean evaluate(Rewrite event, EvaluationContext context) {
        boolean result = true;
        for (int i = 0; i < this.conditions.length; ++i) {
            if (this.conditions[i].evaluate(event, context)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public List<Condition> getConditions() {
        return Arrays.asList(this.conditions);
    }

    public String toString() {
        return "And.all(" + Strings.join(this.getConditions(), ", ") + ")";
    }
}

