/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexConstraint;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.util.ParseTools;

public class RegexParameterizedPatternParser
implements ParameterizedPatternParser {
    private static final String DEFAULT_PARAMETER_PATTERN = ".*";
    private Pattern compiledPattern;
    private final String pattern;
    private final char[] chars;
    private final List<RegexGroup> groups = new ArrayList<RegexGroup>();
    private RegexParameterizedPatternBuilder builder;
    private String defaultParameterPattern;
    private ParameterStore store;

    RegexParameterizedPatternParser(RegexParameterizedPatternBuilder builder, String defaultParameterPattern, String pattern) {
        this(defaultParameterPattern, pattern);
        this.builder = builder;
    }

    public RegexParameterizedPatternParser(String pattern) {
        this(ParseTools.CaptureType.BRACE, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternParser(String parameterPattern, String pattern) {
        this(ParseTools.CaptureType.BRACE, parameterPattern, pattern);
    }

    public RegexParameterizedPatternParser(ParseTools.CaptureType type, String pattern) {
        this(type, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternParser(ParseTools.CaptureType type, String defaultParameterPattern, String pattern) {
        Assert.notNull(pattern, "Pattern must not be null");
        this.defaultParameterPattern = defaultParameterPattern;
        this.pattern = pattern;
        this.chars = pattern.toCharArray();
        if (this.chars.length > 0) {
            int parameterIndex = 0;
            block3: for (int cursor = 0; cursor < this.chars.length; ++cursor) {
                switch (this.chars[cursor]) {
                    case '{': {
                        int startPos = cursor;
                        ParseTools.CapturingGroup group = ParseTools.balancedCapture(this.chars, startPos, this.chars.length - 1, type);
                        cursor = group.getEnd();
                        this.groups.add(new RegexGroup(group, parameterIndex++));
                        continue block3;
                    }
                }
            }
        }
    }

    @Override
    public ParameterizedPatternResult parse(String value) {
        return new RegexParameterizedPatternMatchResult(this.groups, this.getCompiledPattern(this.store).matcher(value));
    }

    public Pattern getCompiledPattern(ParameterStore store) {
        if (this.compiledPattern == null) {
            StringBuilder patternBuilder = new StringBuilder();
            ParseTools.CapturingGroup last = null;
            for (RegexGroup group : this.groups) {
                ParseTools.CapturingGroup capture = group.getCapture();
                if (last != null && last.getEnd() < capture.getStart() - 1) {
                    patternBuilder.append(new char[]{'\\', 'Q'});
                    patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
                    patternBuilder.append(new char[]{'\\', 'E'});
                } else if (last == null && capture.getStart() > 0) {
                    patternBuilder.append(new char[]{'\\', 'Q'});
                    patternBuilder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
                    patternBuilder.append(new char[]{'\\', 'E'});
                }
                patternBuilder.append('(');
                StringBuilder parameterPatternBuilder = new StringBuilder();
                if (store != null && store.contains(group.getName())) {
                    Iterator<Constraint<String>> iterator = store.get(group.getName()).getConstraints().iterator();
                    while (iterator.hasNext()) {
                        Constraint<String> constraint = iterator.next();
                        if (!(constraint instanceof RegexConstraint)) continue;
                        parameterPatternBuilder.append("(?:");
                        parameterPatternBuilder.append(((RegexConstraint)constraint).getPattern());
                        parameterPatternBuilder.append(")");
                        if (!iterator.hasNext()) continue;
                        parameterPatternBuilder.append("|");
                    }
                }
                if (parameterPatternBuilder.length() > 0) {
                    patternBuilder.append((CharSequence)parameterPatternBuilder);
                } else {
                    patternBuilder.append(this.defaultParameterPattern);
                }
                patternBuilder.append(')');
                last = capture;
            }
            if (last != null && last.getEnd() < this.chars.length) {
                patternBuilder.append(new char[]{'\\', 'Q'});
                patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
                patternBuilder.append(new char[]{'\\', 'E'});
            } else if (last == null) {
                patternBuilder.append(new char[]{'\\', 'Q'});
                patternBuilder.append(this.chars);
                patternBuilder.append(new char[]{'\\', 'E'});
            }
            this.compiledPattern = Pattern.compile(patternBuilder.toString());
        }
        return this.compiledPattern;
    }

    public String toString() {
        return new String(this.chars);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public ParameterizedPatternBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new RegexParameterizedPatternBuilder(this.pattern, this);
            this.builder.setParameterStore(this.store);
        }
        return this.builder;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (RegexGroup group : this.groups) {
            result.add(group.getName());
        }
        return result;
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.store = store;
    }

    private static class RegexParameterizedPatternMatchResult
    implements ParameterizedPatternResult {
        private Matcher matcher;
        private List<RegexGroup> groups;
        private Boolean matched;

        public RegexParameterizedPatternMatchResult(List<RegexGroup> groups, Matcher matcher) {
            this.groups = groups;
            this.matcher = matcher;
        }

        @Override
        public boolean matches() {
            if (this.matched == null) {
                this.matched = this.matcher.matches();
            }
            return this.matched;
        }

        @Override
        public Map<Parameter<?>, String> getParameters(EvaluationContext context) {
            LinkedHashMap values = new LinkedHashMap();
            ParameterStore store = DefaultParameterStore.getInstance(context);
            if (this.matcher.matches()) {
                for (RegexGroup group : this.groups) {
                    values.put(store.get(group.getName()), this.matcher.group(group.getIndex() + 1));
                }
            }
            return values;
        }

        @Override
        public boolean submit(Rewrite event, EvaluationContext context) {
            if (this.matches()) {
                ParameterStore store = DefaultParameterStore.getInstance(context);
                int index = 1;
                for (RegexGroup group : this.groups) {
                    String value = this.matcher.group(index++);
                    Parameter<?> param = store.get(group.getName());
                    ParameterValueStore valueStore = DefaultParameterValueStore.getInstance(context);
                    if (valueStore.submit(event, context, param, value)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class RegexGroup {
        private final ParseTools.CapturingGroup capture;
        private final int index;

        public RegexGroup(ParseTools.CapturingGroup capture, int index) {
            this.capture = capture;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return new String(this.capture.getCaptured());
        }

        public ParseTools.CapturingGroup getCapture() {
            return this.capture;
        }

        public String toString() {
            return "RegexParameter [name=" + this.getName() + ", capture=" + this.capture + "]";
        }
    }
}

