/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.spi;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.DigesterPrettyConfigParser;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.spi.ConfigurationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class ContextSpecifiedConfigurationProvider
implements ConfigurationProvider {
    private static final Log log = LogFactory.getLog(ContextSpecifiedConfigurationProvider.class);

    @Override
    public PrettyConfig loadConfiguration(ServletContext servletContext) {
        PrettyConfigBuilder builder = new PrettyConfigBuilder();
        DigesterPrettyConfigParser configParser = new DigesterPrettyConfigParser();
        List<String> configFilesList = this.getConfigFilesList(servletContext);
        for (String configFilePath : configFilesList) {
            InputStream is = servletContext.getResourceAsStream(configFilePath);
            if (is == null) {
                log.error("Pretty Faces config resource [" + configFilePath + "] not found.");
                continue;
            }
            log.trace("Reading config [" + configFilePath + "].");
            try {
                configParser.parse(builder, is);
            }
            catch (Exception e) {
                throw new PrettyException("Failed to parse PrettyFaces configuration from " + configFilePath, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return builder.build();
    }

    private List<String> getConfigFilesList(ServletContext context) {
        String configFiles = context.getInitParameter("com.ocpsoft.pretty.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if ("/WEB-INF/pretty-config.xml".equals(systemId)) {
                    log.warn("The file [/WEB-INF/pretty-config.xml] has been specified in the [com.ocpsoft.pretty.CONFIG_FILES] context parameter of the deployment descriptor; this is unecessary and will be ignored.");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }
}

