/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.ocpsoft.rewrite.servlet.spi.ContextListener;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringServletContextLoader
implements ContextListener {
    private static final Map<ClassLoader, ServletContext> contextMap = new ConcurrentHashMap<ClassLoader, ServletContext>(1);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        contextMap.put(Thread.currentThread().getContextClassLoader(), servletContext);
        contextMap.put(servletContext.getClassLoader(), servletContext);
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        contextMap.entrySet().removeIf(entry -> entry.getValue() == context);
    }

    public static ServletContext findCurrentServletContext() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest().getServletContext();
        }
        return contextMap.get(Thread.currentThread().getContextClassLoader());
    }

    public static WebApplicationContext findCurrentApplicationContext() {
        WebApplicationContext webApplicationContext;
        ServletContext currentServletContext = SpringServletContextLoader.findCurrentServletContext();
        if (currentServletContext != null && (webApplicationContext = WebApplicationContextUtils.findWebApplicationContext((ServletContext)currentServletContext)) != null) {
            return webApplicationContext;
        }
        return ContextLoader.getCurrentWebApplicationContext();
    }

    public int priority() {
        return 0;
    }
}

