/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.faces.RewriteNavigationHandler;
import org.ocpsoft.rewrite.faces.URLDuplicatePathCanonicalizer;
import org.ocpsoft.rewrite.faces.spi.FacesActionUrlProvider;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class RewriteViewHandler
extends ViewHandlerWrapper {
    protected ViewHandler parent;
    private final ThreadLocal<Boolean> bookmarkable = new ThreadLocal();
    private volatile List<FacesActionUrlProvider> providers;

    private boolean isBookmarkable() {
        Boolean result = this.bookmarkable.get();
        if (result == null) {
            result = false;
            this.bookmarkable.set(result);
        }
        return result;
    }

    private void setBookmarkable(boolean value) {
        this.bookmarkable.set(value);
    }

    public RewriteViewHandler(ViewHandler viewHandler) {
        this.parent = viewHandler;
    }

    public String getActionURL(FacesContext context, String viewId) {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        String result = null;
        if (!this.isBookmarkable() && !RewriteNavigationHandler.isInNavigation(request) && viewId != null && viewId.equals(context.getViewRoot().getViewId())) {
            String parentActionURL;
            FacesActionUrlProvider provider;
            Iterator<FacesActionUrlProvider> iterator = this.getProviders().iterator();
            while (iterator.hasNext() && (result = (provider = iterator.next()).getActionURL(context, viewId)) == null) {
            }
            if (result != null && (parentActionURL = this.parent.getActionURL(context, viewId)).contains("?")) {
                URLBuilder builder = URLBuilder.createFrom((String)result);
                builder.getQueryStringBuilder().addParameters(parentActionURL);
                result = builder.toURL();
            }
        }
        if (result == null) {
            result = this.parent.getActionURL(context, viewId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FacesActionUrlProvider> getProviders() {
        List result = this.providers;
        if (result == null) {
            RewriteViewHandler rewriteViewHandler = this;
            synchronized (rewriteViewHandler) {
                result = this.providers;
                if (result == null) {
                    result = Iterators.asList((Iterable)ServiceLoader.load(FacesActionUrlProvider.class));
                    Collections.sort(result, new WeightedComparator());
                    this.providers = result;
                }
            }
        }
        return result;
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        this.setBookmarkable(true);
        String result = this.parent.getBookmarkableURL(context, viewId, parameters, includeViewParams);
        this.setBookmarkable(false);
        return result;
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        String canonicalViewId = new URLDuplicatePathCanonicalizer().canonicalize(rawViewId);
        return this.parent.deriveViewId(context, canonicalViewId);
    }

    public ViewHandler getWrapped() {
        return this.parent;
    }
}

