/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.RegexParameter;
import org.ocpsoft.rewrite.bind.parse.CaptureType;
import org.ocpsoft.rewrite.bind.parse.CapturingGroup;
import org.ocpsoft.rewrite.bind.parse.ParseTools;
import org.ocpsoft.rewrite.bind.util.Maps;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.Transform;

public class ParameterizedPattern {
    private static final String DEFAULT_PARAMETER_PATTERN = ".*";
    private Pattern pattern;
    private final char[] chars;
    private final Map<String, RegexParameter> params = new LinkedHashMap<String, RegexParameter>();

    public ParameterizedPattern(String pattern) {
        this(CaptureType.BRACE, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public ParameterizedPattern(String parameterPattern, String pattern) {
        this(CaptureType.BRACE, parameterPattern, pattern);
    }

    public ParameterizedPattern(CaptureType type, String pattern) {
        this(type, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public ParameterizedPattern(CaptureType type, String parameterPattern, String pattern) {
        this.chars = pattern.toCharArray();
        if (this.chars.length > 0) {
            block3: for (int cursor = 0; cursor < this.chars.length; ++cursor) {
                switch (this.chars[cursor]) {
                    case '{': {
                        int startPos = cursor;
                        CapturingGroup group = ParseTools.balancedCapture(this.chars, startPos, this.chars.length - 1, type);
                        cursor = group.getEnd();
                        String parameterName = new String(group.getCaptured());
                        RegexParameter parameter = new RegexParameter(group);
                        this.params.put(parameterName, parameter.matches(parameterPattern));
                        continue block3;
                    }
                }
            }
        }
    }

    public Map<String, RegexParameter> getParameters() {
        return this.params;
    }

    public String build(Rewrite event, EvaluationContext context) {
        return this.build(this.extractBoundValues(event, context));
    }

    public String build(Object ... values) {
        if (values == null || this.params.size() != values.length) {
            throw new IllegalArgumentException("Must supply [" + this.params.size() + "] values to build output string.");
        }
        return this.buildUnsafe(values);
    }

    public String buildUnsafe(Object ... values) {
        StringBuilder builder = new StringBuilder();
        CapturingGroup last = null;
        int index = 0;
        for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
            RegexParameter param = entry.getValue();
            CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            builder.append(values[index]);
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        return builder.toString();
    }

    public String build(Map<String, List<Object>> values) {
        if (values == null || this.params.size() != values.size()) {
            throw new IllegalArgumentException("Must supply [" + this.params.size() + "] values to build output string.");
        }
        return this.buildUnsafe(values);
    }

    public String buildUnsafe(Map<String, List<Object>> values) {
        StringBuilder builder = new StringBuilder();
        CapturingGroup last = null;
        LinkedHashMap<String, Integer> pointers = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
            RegexParameter param = entry.getValue();
            CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            String name = param.getName();
            int index = pointers.get(name) == null ? 0 : (Integer)pointers.get(name);
            builder.append(Maps.getListValue(values, name, index));
            pointers.put(name, index++);
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        return builder.toString();
    }

    public boolean matches(Rewrite event, EvaluationContext context, String value) {
        Matcher matcher;
        boolean result;
        if (this.pattern == null) {
            StringBuilder patternBuilder = new StringBuilder();
            CapturingGroup last = null;
            for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
                RegexParameter param = entry.getValue();
                CapturingGroup capture = param.getCapture();
                if (last != null && last.getEnd() < capture.getStart()) {
                    patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
                } else if (last == null && capture.getStart() > 0) {
                    patternBuilder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
                }
                patternBuilder.append('(');
                patternBuilder.append(param.getPattern());
                patternBuilder.append(')');
                last = capture;
            }
            if (last != null && last.getEnd() < this.chars.length) {
                patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
            } else if (last == null) {
                patternBuilder.append(this.chars);
            }
            this.pattern = Pattern.compile(patternBuilder.toString());
        }
        if (result = (matcher = this.pattern.matcher(value)).matches()) {
            int group = 1;
            block1: for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
                RegexParameter param = entry.getValue();
                String matched = matcher.group(group++);
                for (Constraint c : param.getConstraints()) {
                    if (c.isSatisfiedBy(event, context, matched)) continue;
                    result = false;
                    break block1;
                }
            }
        }
        return result;
    }

    public Map<RegexParameter, String[]> parse(Rewrite event, EvaluationContext context, String path) {
        LinkedHashMap<RegexParameter, String[]> values = new LinkedHashMap<RegexParameter, String[]>();
        String temp = path;
        if (this.matches(event, context, path)) {
            CapturingGroup last = null;
            Set<Map.Entry<String, RegexParameter>> entrySet = this.params.entrySet();
            ArrayList<Map.Entry<String, RegexParameter>> entries = new ArrayList<Map.Entry<String, RegexParameter>>(entrySet);
            for (int i = 0; i < entries.size(); ++i) {
                Map.Entry entry = (Map.Entry)entries.get(i);
                RegexParameter param = (RegexParameter)((Object)entry.getValue());
                CapturingGroup capture = param.getCapture();
                if (last != null && last.getEnd() < capture.getStart()) {
                    temp = temp.substring(capture.getStart() - (last.getEnd() + 1));
                } else if (last == null && capture.getStart() > 0) {
                    temp = temp.substring(capture.getStart());
                }
                StringBuilder segmentBuilder = new StringBuilder();
                segmentBuilder.append('(');
                segmentBuilder.append(param.getPattern());
                segmentBuilder.append(')');
                if (i + 1 < entries.size()) {
                    Map.Entry next = (Map.Entry)entries.get(i + 1);
                    CapturingGroup nextCapture = ((RegexParameter)((Object)next.getValue())).getCapture();
                    char[] tail = Arrays.copyOfRange(this.chars, capture.getEnd() + 1, nextCapture.getStart());
                    segmentBuilder.append(tail);
                } else {
                    char[] tail = Arrays.copyOfRange(this.chars, capture.getEnd() + 1, this.chars.length);
                    segmentBuilder.append(tail);
                }
                Pattern segmentPattern = Pattern.compile(segmentBuilder.toString() + DEFAULT_PARAMETER_PATTERN);
                Matcher segmentMatcher = segmentPattern.matcher(temp);
                if (segmentMatcher.matches()) {
                    String value = segmentMatcher.group(1);
                    value = this.applyTransforms(event, context, param, value);
                    Maps.addArrayValue(values, param, value);
                    temp = temp.substring(segmentMatcher.end(1));
                }
                last = capture;
            }
        }
        return values;
    }

    private String applyTransforms(Rewrite event, EvaluationContext context, RegexParameter param, String value) {
        String result = value;
        for (Transform t : param.getTransforms()) {
            result = (String)t.transform(event, context, (Object)value);
        }
        return result;
    }

    public RegexParameter getParameter(String name) {
        return this.params.get(name);
    }

    private Map<String, List<Object>> extractBoundValues(Rewrite event, EvaluationContext context) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
            String name = entry.getKey();
            Parameter parameter = (Parameter)entry.getValue();
            List values = Bindings.performRetrieval((Rewrite)event, (EvaluationContext)context, (Bindable)parameter);
            for (Object boundValue : values) {
                if (boundValue.getClass().isArray()) {
                    for (Object temp : (Object[])boundValue) {
                        Maps.addListValue(result, name, temp);
                    }
                    continue;
                }
                Maps.addListValue(result, name, boundValue);
            }
        }
        return result;
    }

    public List<String> getParameterNames() {
        return new ArrayList<String>(this.params.keySet());
    }

    public String toString() {
        return new String(this.chars);
    }
}

