/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.parse.CaptureType;
import org.ocpsoft.rewrite.bind.parse.CapturingGroup;
import org.ocpsoft.rewrite.bind.parse.ParseTools;
import org.ocpsoft.rewrite.bind.util.Maps;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.param.Transform;

public class ParameterizedPattern {
    private static final String DEFAULT_PARAMETER_PATTERN = ".*";
    private Pattern pattern;
    private final char[] chars;
    private final Map<String, RegexParameter> params = new LinkedHashMap<String, RegexParameter>();

    public ParameterizedPattern(String pattern) {
        this(CaptureType.BRACE, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public ParameterizedPattern(String parameterPattern, String pattern) {
        this(CaptureType.BRACE, parameterPattern, pattern);
    }

    public ParameterizedPattern(CaptureType type, String pattern) {
        this(type, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public ParameterizedPattern(CaptureType type, String parameterPattern, String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        this.chars = pattern.toCharArray();
        if (this.chars.length > 0) {
            int parameterIndex = 0;
            block3: for (int cursor = 0; cursor < this.chars.length; ++cursor) {
                switch (this.chars[cursor]) {
                    case '{': {
                        int startPos = cursor;
                        CapturingGroup group = ParseTools.balancedCapture(this.chars, startPos, this.chars.length - 1, type);
                        cursor = group.getEnd();
                        String parameterName = new String(group.getCaptured());
                        RegexParameter parameter = new RegexParameter(group, parameterIndex++);
                        this.params.put(parameterName, parameter.matches(parameterPattern));
                        continue block3;
                    }
                }
            }
        }
    }

    public Map<String, RegexParameter> getParameters() {
        return this.params;
    }

    public String build(Rewrite event, EvaluationContext context) {
        return this.build(this.extractBoundValues(event, context));
    }

    public String build(Object ... values) {
        if (values == null || this.params.size() != values.length) {
            throw new IllegalArgumentException("Must supply [" + this.params.size() + "] values to build output string.");
        }
        return this.buildUnsafe(values);
    }

    public String buildUnsafe(Object ... values) {
        StringBuilder builder = new StringBuilder();
        CapturingGroup last = null;
        int index = 0;
        for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
            RegexParameter param = entry.getValue();
            CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            builder.append(values[index]);
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        return builder.toString();
    }

    public String build(Map<String, List<Object>> values) {
        if (values == null || this.params.size() != values.size()) {
            throw new IllegalArgumentException("Must supply [" + this.params.size() + "] values to build output string.");
        }
        return this.buildUnsafe(values);
    }

    public String buildUnsafe(Map<String, List<Object>> values) {
        StringBuilder builder = new StringBuilder();
        CapturingGroup last = null;
        LinkedHashMap<String, Integer> pointers = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
            RegexParameter param = entry.getValue();
            CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            String name = param.getName();
            int index = pointers.get(name) == null ? 0 : (Integer)pointers.get(name);
            builder.append(Maps.getListValue(values, name, index));
            pointers.put(name, index++);
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        return builder.toString();
    }

    public boolean matches(Rewrite event, EvaluationContext context, String value) {
        Matcher matcher = this.getMatcher(value);
        boolean result = matcher.matches();
        if (result) {
            int group = 1;
            block0: for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
                RegexParameter param = entry.getValue();
                String matched = matcher.group(group++);
                for (Constraint c : param.getConstraints()) {
                    if (c.isSatisfiedBy(event, context, matched)) continue;
                    result = false;
                    break block0;
                }
            }
        }
        return result;
    }

    public Matcher getMatcher(String value) {
        if (this.pattern == null) {
            StringBuilder patternBuilder = new StringBuilder();
            CapturingGroup last = null;
            for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
                RegexParameter param = entry.getValue();
                CapturingGroup capture = param.getCapture();
                if (last != null && last.getEnd() < capture.getStart() - 1) {
                    patternBuilder.append(new char[]{'\\', 'Q'});
                    patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
                    patternBuilder.append(new char[]{'\\', 'E'});
                } else if (last == null && capture.getStart() > 0) {
                    patternBuilder.append(new char[]{'\\', 'Q'});
                    patternBuilder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
                    patternBuilder.append(new char[]{'\\', 'E'});
                }
                patternBuilder.append('(');
                patternBuilder.append(param.getPattern());
                patternBuilder.append(')');
                last = capture;
            }
            if (last != null && last.getEnd() < this.chars.length) {
                patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
            } else if (last == null) {
                patternBuilder.append(new char[]{'\\', 'Q'});
                patternBuilder.append(this.chars);
                patternBuilder.append(new char[]{'\\', 'E'});
            }
            this.pattern = Pattern.compile(patternBuilder.toString());
        }
        Matcher matcher = this.pattern.matcher(value);
        return matcher;
    }

    public Map<RegexParameter, String[]> parse(Rewrite event, EvaluationContext context, String path) {
        LinkedHashMap<RegexParameter, String[]> values = new LinkedHashMap<RegexParameter, String[]>();
        Matcher matcher = this.getMatcher(path);
        if (matcher.matches()) {
            for (RegexParameter param : this.params.values()) {
                String capturedValue = this.applyTransforms(event, context, param, matcher.group(param.getIndex() + 1));
                Maps.addArrayValue(values, param, capturedValue);
            }
        }
        return values;
    }

    private String applyTransforms(Rewrite event, EvaluationContext context, RegexParameter param, String value) {
        String result = value;
        for (Transform t : param.getTransforms()) {
            result = (String)t.transform(event, context, (Object)value);
        }
        return result;
    }

    public RegexParameter getParameter(String name) {
        return this.params.get(name);
    }

    private Map<String, List<Object>> extractBoundValues(Rewrite event, EvaluationContext context) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<String, RegexParameter> entry : this.params.entrySet()) {
            String name = entry.getKey();
            Parameter parameter = (Parameter)entry.getValue();
            List values = Bindings.performRetrieval((Rewrite)event, (EvaluationContext)context, (Bindable)parameter);
            for (Object boundValue : values) {
                if (boundValue.getClass().isArray()) {
                    for (Object temp : (Object[])boundValue) {
                        Maps.addListValue(result, name, temp);
                    }
                    continue;
                }
                Maps.addListValue(result, name, boundValue);
            }
        }
        return result;
    }

    public List<String> getParameterNames() {
        return new ArrayList<String>(this.params.keySet());
    }

    public String toString() {
        return new String(this.chars);
    }

    public class RegexParameter
    extends ParameterBuilder<RegexParameter, String> {
        private String pattern;
        private final CapturingGroup capture;
        private final int index;

        public RegexParameter(CapturingGroup capture, int index) {
            this.capture = capture;
            this.index = index;
        }

        public RegexParameter matches(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return new String(this.capture.getCaptured());
        }

        public CapturingGroup getCapture() {
            return this.capture;
        }

        public String toString() {
            return "RegexParameter [name=" + this.getName() + ", capture=" + this.capture + "]";
        }
    }
}

