/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.ocpsoft.rewrite.servlet.ServletRegistration;

class WebXmlServletRegistrationParser {
    private final List<ServletRegistration> registrations = new ArrayList<ServletRegistration>();
    private final Stack<String> stack = new Stack();
    private List<ServletEntry> servlets = new ArrayList<ServletEntry>();
    private Map<String, ServletMappingEntry> servletMappings = new LinkedHashMap<String, ServletMappingEntry>();
    private ServletEntry currentServlet;
    private ServletMappingEntry currentServletMapping;

    WebXmlServletRegistrationParser() {
    }

    public void parse(InputStream stream) throws IOException {
        try {
            XMLEvent event;
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(stream);
            while (reader.hasNext() && !(event = reader.nextEvent()).isEndDocument()) {
                if (event.isStartElement()) {
                    this.stack.push(event.asStartElement().getName().getLocalPart());
                }
                this.handleEvent(event);
                if (!event.isEndElement()) continue;
                this.stack.pop();
            }
            for (ServletEntry servletEntry : this.servlets) {
                ServletRegistration reg = new ServletRegistration();
                reg.setClassName(servletEntry.servletClass);
                ServletMappingEntry mapping = this.servletMappings.get(servletEntry.servletName);
                if (mapping != null) {
                    reg.addMappings(mapping.mappings);
                }
                this.registrations.add(reg);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void handleEvent(XMLEvent event) {
        if (this.isParsePosition("web-app", "servlet")) {
            if (event.isStartElement()) {
                this.currentServlet = new ServletEntry();
            }
            if (event.isEndElement()) {
                this.servlets.add(this.currentServlet);
                this.currentServlet = null;
            }
        }
        if (event.isCharacters() && this.isParsePosition("web-app", "servlet", "servlet-name")) {
            this.currentServlet.servletName = event.asCharacters().getData().trim();
        }
        if (event.isCharacters() && this.isParsePosition("web-app", "servlet", "servlet-class")) {
            this.currentServlet.servletClass = event.asCharacters().getData().trim();
        }
        if (this.isParsePosition("web-app", "servlet-mapping")) {
            if (event.isStartElement()) {
                this.currentServletMapping = new ServletMappingEntry();
            }
            if (event.isEndElement() && WebXmlServletRegistrationParser.isNotBlank(this.currentServletMapping.servletName)) {
                String key = this.currentServletMapping.servletName.trim();
                ServletMappingEntry existingMapping = this.servletMappings.get(key);
                if (existingMapping != null) {
                    existingMapping.mappings.addAll(this.currentServletMapping.mappings);
                } else {
                    this.servletMappings.put(key, this.currentServletMapping);
                }
                this.currentServletMapping = null;
            }
        }
        if (event.isCharacters() && this.isParsePosition("web-app", "servlet-mapping", "servlet-name")) {
            this.currentServletMapping.servletName = event.asCharacters().getData().trim();
        }
        if (event.isCharacters() && this.isParsePosition("web-app", "servlet-mapping", "url-pattern")) {
            this.currentServletMapping.mappings.add(event.asCharacters().getData().trim());
        }
    }

    private static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean isParsePosition(String ... path) {
        if (path.length != this.stack.size()) {
            return false;
        }
        for (int i = 0; i < this.stack.size(); ++i) {
            if (path[i].equals(this.stack.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<ServletRegistration> getRegistrations() {
        return this.registrations;
    }

    private class ServletMappingEntry {
        public String servletName;
        public final List<String> mappings = new ArrayList<String>();

        private ServletMappingEntry() {
        }
    }

    private class ServletEntry {
        public String servletName;
        public String servletClass;

        private ServletEntry() {
        }
    }
}

