/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.DefaultBindable;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class RequestParameter
extends HttpCondition {
    private final String name;
    private final Pattern nameRegex;
    private final Pattern value;
    private final DefaultBindable<?> bindable = new DefaultBindable();

    private RequestParameter(String name, String nameRegex, String valueRegex) {
        Assert.notNull((Object)nameRegex, (String)"Parameter name pattern cannot be null.");
        Assert.notNull((Object)valueRegex, (String)"Parameter value pattern cannot be null.");
        this.name = name;
        this.nameRegex = Pattern.compile(nameRegex);
        this.value = Pattern.compile(valueRegex);
        this.bindsTo((Binding)Evaluation.property((CharSequence)nameRegex));
    }

    public RequestParameter bindsTo(Binding binding) {
        this.bindable.bindsTo(binding);
        return this;
    }

    public static RequestParameter matches(String nameRegex, String valueRegex) {
        return new RequestParameter(null, nameRegex, valueRegex);
    }

    public static RequestParameter exists(String name) {
        return new RequestParameter(name, name, ".*");
    }

    public static RequestParameter existsMatching(String nameRegex) {
        return new RequestParameter(null, nameRegex, ".*");
    }

    public static RequestParameter valueExists(String valueRegex) {
        return new RequestParameter(null, ".*", valueRegex);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String matchedParameter = null;
        ArrayList<String> values = new ArrayList<String>();
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String parameter : Collections.list(request.getParameterNames())) {
            if (this.name != null) {
                if (!this.name.equals(parameter)) continue;
                matchedParameter = this.name;
                values.addAll(Arrays.asList(request.getParameterValues(matchedParameter)));
                break;
            }
            if (!this.nameRegex.matcher(parameter).matches() || !this.matchesValue(request, parameter)) continue;
            matchedParameter = parameter;
            values.addAll(Arrays.asList(request.getParameterValues(matchedParameter)));
        }
        if (matchedParameter != null) {
            Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, this.bindable, (Object)values.toArray(new String[0]));
            return true;
        }
        return false;
    }

    private boolean matchesValue(HttpServletRequest request, String parameter) {
        for (String contents : Arrays.asList(request.getParameterValues(parameter))) {
            if (!this.value.matcher(contents).matches()) continue;
            return true;
        }
        return false;
    }
}

