/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexConditionParameterBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ConditionParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterizedCondition;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class RequestParameter
extends HttpCondition
implements ParameterizedCondition<ConditionParameterBuilder<RegexConditionParameterBuilder, String>, String> {
    private final ParameterizedPattern name;
    private final ParameterizedPattern value;

    private RequestParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Header name pattern cannot be null.");
        Assert.notNull((Object)value, (String)"Header value pattern cannot be null.");
        this.name = new ParameterizedPattern(name);
        this.value = new ParameterizedPattern(value);
    }

    public static RequestParameter matches(String name, String value) {
        return new RequestParameter(name, value);
    }

    public static RequestParameter exists(String name) {
        return new RequestParameter(name, "{" + RequestParameter.class.getName() + "_value}");
    }

    public static RequestParameter valueExists(String value) {
        return new RequestParameter("{" + RequestParameter.class.getName() + "_name}", value);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String header : Collections.list(request.getParameterNames())) {
            if (!this.name.matches((Rewrite)event, context, header) || !this.matchesValue((Rewrite)event, context, request, header)) continue;
            Map parameters = this.name.parse((Rewrite)event, context, header);
            parameters = this.value.parse((Rewrite)event, context, header);
            if (!Bindings.enqueuePreOperationSubmissions((Rewrite)event, (EvaluationContext)context, (Map)parameters) || !Bindings.enqueuePreOperationSubmissions((Rewrite)event, (EvaluationContext)context, (Map)parameters)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Arrays.asList(request.getParameterValues(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }

    public RegexConditionParameterBuilder where(String param) {
        return new RegexConditionParameterBuilder((ParameterizedCondition)this, new ParameterizedPattern.RegexParameter[]{this.name.getParameter(param), this.value.getParameter(param)});
    }

    public RegexConditionParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    public RegexConditionParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    public RegexConditionParameterBuilder where(String param, Binding binding) {
        return this.where(param, binding);
    }
}

