/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexConditionParameterBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ConditionParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterizedCondition;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class URL
extends HttpCondition
implements ParameterizedCondition<ConditionParameterBuilder<RegexConditionParameterBuilder, String>, String> {
    private final ParameterizedPattern expression;

    private URL(String pattern) {
        Assert.notNull((Object)pattern, (String)"URL must not be null.");
        this.expression = new ParameterizedPattern(".*", pattern);
        for (ParameterizedPattern.RegexParameter parameter : this.expression.getParameters().values()) {
            parameter.bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public static URL matches(String pattern) {
        return new URL(pattern);
    }

    public static URL captureIn(String param) {
        URL path = new URL("{" + param + "}");
        return path;
    }

    public URL withRequestBinding() {
        for (ParameterizedPattern.RegexParameter parameter : this.expression.getParameters().values()) {
            parameter.bindsTo((Binding)Request.parameter(parameter.getName()));
        }
        return this;
    }

    public RegexConditionParameterBuilder where(String param) {
        return new RegexConditionParameterBuilder((ParameterizedCondition)this, new ParameterizedPattern.RegexParameter[]{this.expression.getParameter(param)});
    }

    public RegexConditionParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    public RegexConditionParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    public RegexConditionParameterBuilder where(String param, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param).bindsTo(binding);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        Map parameters;
        String requestURL = null;
        if (event instanceof HttpOutboundServletRewrite) {
            requestURL = ((HttpOutboundServletRewrite)event).getOutboundURL();
            if (requestURL.startsWith(event.getContextPath())) {
                requestURL = requestURL.substring(event.getContextPath().length());
            }
        } else {
            HttpServletRequest request = (HttpServletRequest)event.getRequest();
            requestURL = event.getContextPath() + event.getURL();
            requestURL = request.getScheme() + "://" + request.getServerName() + (request.getServerPort() != 80 ? ":" + request.getServerPort() : "") + requestURL;
        }
        return this.expression.matches((Rewrite)event, context, requestURL) && Bindings.enqueuePreOperationSubmissions((Rewrite)event, (EvaluationContext)context, (Map)(parameters = this.expression.parse((Rewrite)event, context, requestURL)));
    }

    public ParameterizedPattern getPathExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }
}

