/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IPath;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class Path
extends HttpCondition
implements IPath {
    private final ParameterizedPattern expression;
    private final ParameterStore<IPath.PathParameter> parameters = new ParameterStore();

    private Path(String pattern) {
        Assert.notNull((Object)pattern, (String)"Path must not be null.");
        this.expression = new ParameterizedPattern("[^/]+", pattern);
        for (RegexCapture parameter : this.expression.getParameters().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public static IPath matches(String pattern) {
        return new Path(pattern);
    }

    public static IPath captureIn(String param) {
        Path path = new Path("{" + param + "}");
        path.where(param).matches(".*");
        return path;
    }

    @Override
    public IPath withRequestBinding() {
        for (RegexCapture capture : this.expression.getParameters().values()) {
            this.where(capture.getName()).bindsTo((Binding)Request.parameter(capture.getName()));
        }
        return this;
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String requestURL = null;
        if (event instanceof HttpOutboundServletRewrite) {
            requestURL = ((HttpOutboundServletRewrite)event).getOutboundURL().split("\\?")[0];
            if (requestURL.startsWith(event.getContextPath())) {
                requestURL = requestURL.substring(event.getContextPath().length());
            }
        } else {
            requestURL = event.getRequestPath();
        }
        if (this.expression.matches((Rewrite)event, context, requestURL)) {
            Map parameters = this.expression.parse((Rewrite)event, context, requestURL);
            for (RegexCapture capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public ParameterizedPattern getPathExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public IPath.PathParameter where(String param) {
        return this.parameters.where(param, new IPath.PathParameter(this, this.expression.getParameter(param)));
    }

    public IPath.PathParameter where(String param, Binding binding) {
        return (IPath.PathParameter)this.where(param).bindsTo(binding);
    }
}

