/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IDomain;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class Domain
extends HttpCondition
implements IDomain {
    private final ParameterizedPattern expression;
    private final ParameterStore<IDomain.DomainParameter> parameters = new ParameterStore();

    private Domain(String pattern) {
        Assert.notNull((Object)pattern, (String)"Domain must not be null.");
        this.expression = new ParameterizedPattern(pattern);
    }

    public static Domain matches(String pattern) {
        return new Domain(pattern);
    }

    public IDomain.DomainParameter where(String param) {
        return this.parameters.where(param, new IDomain.DomainParameter(this, this.expression.getParameter(param)));
    }

    public IDomain.DomainParameter where(String param, Binding binding) {
        return (IDomain.DomainParameter)this.where(param).bindsTo(binding);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String hostName = null;
        if (event instanceof HttpOutboundServletRewrite) {
            String url = event.getURL();
            URLBuilder builder = URLBuilder.createFrom(url);
            hostName = builder.toURI().getHost();
            if (hostName == null) {
                hostName = ((HttpServletRequest)event.getRequest()).getServerName();
            }
        } else {
            hostName = ((HttpServletRequest)event.getRequest()).getServerName();
        }
        if (hostName != null && this.expression.matches((Rewrite)event, context, hostName)) {
            Map parameters = this.expression.parse((Rewrite)event, context, hostName);
            for (RegexCapture parameter : this.expression.getParameters().values()) {
                this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
            }
            for (RegexCapture capture : parameters.keySet()) {
                if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)this.where(capture.getName()), parameters.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ParameterizedPattern getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public IDomain withRequestBinding() {
        for (RegexCapture parameter : this.expression.getParameters().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Request.parameter(parameter.getName()));
        }
        return this;
    }

    @Override
    public ParameterizedPattern getDomainExpression() {
        return this.expression;
    }
}

