/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.IRedirect;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class Redirect
extends HttpOperation
implements IRedirect {
    private final RedirectType type;
    private final ParameterizedPattern location;
    private final ParameterStore<IRedirect.RedirectParameter> parameters = new ParameterStore();

    private Redirect(String location, RedirectType type) {
        this.location = new ParameterizedPattern("[^/]+", location);
        this.type = type;
        for (RegexCapture parameter : this.location.getParameters().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build((Rewrite)event, context, this.parameters.getParameters());
            switch (this.type) {
                case PERMANENT: {
                    ((HttpInboundServletRewrite)event).redirectPermanent(target);
                    break;
                }
                case TEMPORARY: {
                    ((HttpInboundServletRewrite)event).redirectTemporary(target);
                    break;
                }
            }
        }
    }

    public static Redirect permanent(String location) {
        return new Redirect(location, RedirectType.PERMANENT);
    }

    public static Redirect temporary(String location) {
        return new Redirect(location, RedirectType.TEMPORARY);
    }

    public IRedirect.RedirectParameter where(String param) {
        return this.parameters.where(param, new IRedirect.RedirectParameter(this, this.location.getParameter(param)));
    }

    public IRedirect.RedirectParameter where(String param, Binding binding) {
        return (IRedirect.RedirectParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public ParameterizedPattern getTargetExpression() {
        return this.location;
    }

    public String toString() {
        return "Redirect [type=" + (Object)((Object)this.type) + ", location=" + this.location + ", parameters=" + this.parameters + "]";
    }

    private static enum RedirectType {
        PERMANENT,
        TEMPORARY;

    }
}

