/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IServletMapping;
import org.ocpsoft.rewrite.servlet.config.Resource;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class ServletMapping
extends HttpCondition
implements IServletMapping {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final ParameterizedPattern resource;
    private final ParameterStore<IServletMapping.ServletMappingParameter> parameters = new ParameterStore();

    private ServletMapping(String resource) {
        this.resource = new ParameterizedPattern(resource);
        for (RegexCapture parameter : this.resource.getParameters().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null) {
            String path = this.resource.build((Rewrite)event, context, this.parameters.getParameters());
            try {
                for (Map.Entry entry : ((HttpServletRequest)event.getRequest()).getServletContext().getServletRegistrations().entrySet()) {
                    ServletRegistration servlet = (ServletRegistration)entry.getValue();
                    Collection mappings = servlet.getMappings();
                    for (String mapping : mappings) {
                        if (path.startsWith("/") && !mapping.startsWith("/")) {
                            mapping = "/" + mapping;
                        }
                        if (mapping.contains("*")) {
                            mapping = mapping.replaceAll("\\*", ".*");
                        }
                        if (!path.matches(mapping)) continue;
                        return true;
                    }
                }
                return ((HttpServletRequest)event.getRequest()).getServletContext().getResource(path) != null;
            }
            catch (MalformedURLException e) {
                log.debug("Invalid file format [{}]", (Object)path);
            }
        }
        return false;
    }

    public static ServletMapping includes(String resource) {
        return new ServletMapping(resource);
    }

    public IServletMapping.ServletMappingParameter where(String param) {
        return this.parameters.where(param, new IServletMapping.ServletMappingParameter(this, this.resource.getParameter(param)));
    }

    public IServletMapping.ServletMappingParameter where(String param, Binding binding) {
        return (IServletMapping.ServletMappingParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public ParameterizedPattern getResourceExpression() {
        return this.resource;
    }
}

