/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public abstract class BaseHttpRewrite
extends BaseRewrite<HttpServletRequest, HttpServletResponse>
implements HttpServletRewrite {
    private static final Pattern JSESSIONID_PATTERN = Pattern.compile("(?i)^(.*);jsessionid=[\\w\\.\\-]+(.*)");
    private static final String JSESSIONID_REPLACEMENT = "$1$2";
    private String requestContextPath;
    private Address address;

    public BaseHttpRewrite(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super((ServletRequest)request, (ServletResponse)response, servletContext);
    }

    public String getContextPath() {
        if (this.requestContextPath == null) {
            this.requestContextPath = ((HttpServletRequest)this.getRequest()).getContextPath();
        }
        return this.requestContextPath;
    }

    public Address getAddress() {
        return this.getInboundAddress();
    }

    public Address getInboundAddress() {
        if (this.address == null) {
            String requestURI = ((HttpServletRequest)this.getRequest()).getRequestURI();
            Matcher sessionIdMatcher = JSESSIONID_PATTERN.matcher(requestURI);
            if (sessionIdMatcher.matches()) {
                requestURI = sessionIdMatcher.replaceFirst(JSESSIONID_REPLACEMENT);
            }
            this.address = AddressBuilder.begin().protocol((CharSequence)((HttpServletRequest)this.getRequest()).getScheme()).host((CharSequence)((HttpServletRequest)this.getRequest()).getServerName()).port(((HttpServletRequest)this.getRequest()).getServerPort()).pathEncoded((CharSequence)requestURI).queryLiteral(((HttpServletRequest)this.getRequest()).getQueryString()).build();
        }
        return this.address;
    }
}

