/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.event.Flow;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.spi.RewriteResultHandler;

public class HttpRewriteResultHandler
implements RewriteResultHandler {
    private static final Logger log = Logger.getLogger(HttpRewriteResultHandler.class);

    public int priority() {
        return 0;
    }

    public boolean handles(Rewrite payload) {
        return payload instanceof HttpInboundServletRewrite;
    }

    public void handleResult(Rewrite event) {
        try {
            HttpInboundServletRewrite servletRewrite = (HttpInboundServletRewrite)event;
            String dispatchResource = servletRewrite.getDispatchResource();
            if (servletRewrite.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
                if (servletRewrite.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.FORWARD)) {
                    log.debug("Issuing internal FORWARD to [{}].", (Object)dispatchResource);
                    ((HttpServletRequest)servletRewrite.getRequest()).getRequestDispatcher(dispatchResource).forward(servletRewrite.getRequest(), servletRewrite.getResponse());
                } else if (servletRewrite.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.REDIRECT_PERMANENT)) {
                    log.debug("Issuing 301 permanent REDIRECT to [{}].", (Object)dispatchResource);
                    HttpServletResponse response = (HttpServletResponse)servletRewrite.getResponse();
                    response.setStatus(301);
                    response.setHeader("Location", dispatchResource);
                    response.flushBuffer();
                } else if (servletRewrite.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.REDIRECT_TEMPORARY)) {
                    log.debug("Issuing 302 temporary REDIRECT to [{}].", (Object)dispatchResource);
                    HttpServletResponse response = (HttpServletResponse)servletRewrite.getResponse();
                    response.setStatus(302);
                    response.setHeader("Location", dispatchResource);
                    response.flushBuffer();
                } else {
                    log.debug("ABORT requested. Terminating request NOW.");
                }
            } else if (servletRewrite.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.INCLUDE)) {
                log.debug("Issuing internal INCLUDE to [{}].", (Object)dispatchResource);
                ((HttpServletRequest)servletRewrite.getRequest()).getRequestDispatcher(dispatchResource).include(servletRewrite.getRequest(), servletRewrite.getResponse());
            }
        }
        catch (Exception e) {
            throw new RewriteException("Error handling Rewrite result", (Throwable)e);
        }
    }
}

