/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.event.Flow;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.RewriteLifecycleContext;
import org.ocpsoft.rewrite.servlet.RewriteWrappedResponse;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.ResponseStreamWrapper;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.OutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpBufferRewriteImpl;
import org.ocpsoft.rewrite.servlet.impl.ResponseContentImpl;
import org.ocpsoft.rewrite.servlet.impl.ResponseContentInterceptorChainImpl;
import org.ocpsoft.rewrite.servlet.spi.OutboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.rewrite.spi.RewriteProvider;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public class HttpRewriteWrappedResponse
extends RewriteWrappedResponse {
    private final HttpServletRequest request;
    private final ServletContext servletContext;
    private static final Logger log = Logger.getLogger(HttpRewriteWrappedResponse.class);
    private ByteArrayOutputStream bufferedResponseContent = new ByteArrayOutputStream();
    private List<ResponseContentInterceptor> responseContentInterceptors = new ArrayList<ResponseContentInterceptor>();
    private List<ResponseStreamWrapper> responseStreamWrappers = new ArrayList<ResponseStreamWrapper>();
    private boolean contentWritten = false;
    private PrintWriter printWriter;
    private ServletOutputStream outputStream = null;
    private ServletOutputStream wrappedOutputStream = null;

    public HttpRewriteWrappedResponse(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(request, response);
        this.request = request;
        this.servletContext = servletContext;
        if (HttpRewriteWrappedResponse.getCurrentInstance((ServletRequest)request) == null) {
            super.setCurrentInstance((RewriteWrappedResponse)this);
        }
    }

    public boolean isResponseContentIntercepted() {
        return !this.responseContentInterceptors.isEmpty();
    }

    public boolean isResponseStreamWrapped() {
        return !this.responseStreamWrappers.isEmpty();
    }

    public void addContentInterceptor(ResponseContentInterceptor stage) throws IllegalStateException {
        if (this.areStreamsLocked()) {
            throw new IllegalStateException("Cannot add output buffers to Response once request processing has been passed to the application.");
        }
        this.responseContentInterceptors.add(stage);
    }

    public void addStreamWrapper(ResponseStreamWrapper wrapper) {
        if (this.areStreamsLocked()) {
            throw new IllegalStateException("Cannot add output buffers to Response once request processing has been passed to the application.");
        }
        this.responseStreamWrappers.add(wrapper);
    }

    private boolean areStreamsLocked() {
        return this.contentWritten;
    }

    private void lockStreams() {
        this.contentWritten = true;
    }

    public void flushBufferedContent() {
        if (this.isResponseContentIntercepted()) {
            try {
                if (this.bufferedResponseContent != null) {
                    this.bufferedResponseContent.close();
                }
                ResponseContentImpl buffer = new ResponseContentImpl(this.bufferedResponseContent.toByteArray(), Charset.forName(this.getCharacterEncoding()));
                new ResponseContentInterceptorChainImpl(this.responseContentInterceptors).begin(new HttpBufferRewriteImpl(this.request, (HttpServletResponse)this, this.servletContext), buffer);
                if (!Charset.forName(this.getCharacterEncoding()).equals(buffer.getCharset())) {
                    this.setCharacterEncoding(buffer.getCharset().name());
                }
                ServletOutputStream outputStream = this.isResponseStreamWrapped() ? this.wrappedOutputStream : super.getOutputStream();
                Streams.copy((InputStream)new ByteArrayInputStream(buffer.getContents()), (OutputStream)outputStream);
                if (this.printWriter != null) {
                    this.printWriter.close();
                }
            }
            catch (IOException e) {
                throw new RewriteException("Error occurred when flushing response content buffered by " + this.responseContentInterceptors, (Throwable)e);
            }
        }
    }

    public void finishStreamWrappers() {
        if (this.isResponseStreamWrapped()) {
            HttpBufferRewriteImpl event = new HttpBufferRewriteImpl(this.request, (HttpServletResponse)this, this.servletContext);
            for (ResponseStreamWrapper wrapper : this.responseStreamWrappers) {
                wrapper.finish((HttpServletRewrite)event);
            }
        }
    }

    public String toString() {
        if (this.isResponseContentIntercepted()) {
            try {
                return this.bufferedResponseContent.toString(this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RewriteException("Response accepted invalid character encoding " + this.getCharacterEncoding(), (Throwable)e);
            }
        }
        return super.toString();
    }

    public PrintWriter getWriter() {
        if (this.printWriter == null) {
            if (this.isResponseContentIntercepted()) {
                this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.bufferedResponseContent, Charset.forName(this.getCharacterEncoding())), true);
            } else if (this.isResponseStreamWrapped()) {
                this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.getOutputStream(), Charset.forName(this.getCharacterEncoding())), true);
            } else {
                try {
                    this.lockStreams();
                    return super.getWriter();
                }
                catch (IOException e) {
                    throw new RewriteException("Could not get response writer.", (Throwable)e);
                }
            }
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() {
        if (this.outputStream == null) {
            if (this.isResponseContentIntercepted()) {
                this.outputStream = new RewriteServletOutputStream(this.bufferedResponseContent);
            } else {
                try {
                    this.lockStreams();
                    this.outputStream = super.getOutputStream();
                }
                catch (IOException e) {
                    throw new RewriteException("Could not get response output stream.", (Throwable)e);
                }
            }
            if (this.isResponseStreamWrapped() && this.wrappedOutputStream == null) {
                HttpBufferRewriteImpl event = new HttpBufferRewriteImpl(this.request, (HttpServletResponse)this, this.servletContext);
                try {
                    Object wrapped = super.getOutputStream();
                    for (ResponseStreamWrapper wrapper : this.responseStreamWrappers) {
                        wrapped = wrapper.wrap((HttpServletRewrite)event, (OutputStream)wrapped);
                    }
                    this.wrappedOutputStream = new RewriteServletOutputStream((OutputStream)wrapped);
                    if (!this.isResponseContentIntercepted()) {
                        this.outputStream = this.wrappedOutputStream;
                    }
                }
                catch (IOException e) {
                    throw new RewriteException("Could not get response output stream.", (Throwable)e);
                }
            }
        }
        return this.outputStream;
    }

    public void setContentLength(int contentLength) {
        this.lockStreams();
        if (!this.isResponseContentIntercepted()) {
            if (this.isResponseStreamWrapped()) {
                this.setHeader("X-Uncompressed-Content-Length", String.valueOf(contentLength));
            } else {
                super.setContentLength(contentLength);
            }
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isResponseContentIntercepted()) {
            this.bufferedResponseContent.flush();
        } else {
            this.lockStreams();
            super.flushBuffer();
        }
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        Address address = AddressBuilder.create((String)URLBuilder.createFrom((String)url).toURL());
        OutboundServletRewrite<ServletRequest, ServletResponse, Address> event = this.rewrite(address);
        if (event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
            return ((Address)event.getOutboundAddress()).toString();
        }
        return super.encodeRedirectURL(((Address)event.getOutboundAddress()).toString());
    }

    public String encodeURL(String url) {
        Address address = AddressBuilder.create((String)URLBuilder.createFrom((String)url).toURL());
        OutboundServletRewrite<ServletRequest, ServletResponse, Address> event = this.rewrite(address);
        if (event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
            return ((Address)event.getOutboundAddress()).toString();
        }
        return super.encodeURL(((Address)event.getOutboundAddress()).toString());
    }

    private OutboundServletRewrite<ServletRequest, ServletResponse, Address> rewrite(Address address) {
        RewriteLifecycleContext context = (RewriteLifecycleContext)this.request.getAttribute("_com.ocpsoft.rewrite.RequestContext");
        OutboundServletRewrite event = null;
        for (OutboundRewriteProducer producer : context.getOutboundProducers()) {
            if (!producer.handles((Object)address)) continue;
            event = producer.createOutboundRewrite((ServletRequest)this.request, this.getResponse(), this.servletContext, (Object)address);
        }
        if (event == null) {
            log.warn("No instance of [" + OutboundServletRewrite.class + "] was produced. Rewriting is disabled on this outbound event.");
        } else {
            for (RewriteLifecycleListener listener : context.getRewriteLifecycleListeners()) {
                listener.beforeOutboundRewrite(event);
            }
            for (RewriteProvider p : context.getRewriteProviders()) {
                if (!p.handles((Object)event)) continue;
                p.rewrite((Rewrite)event);
                if (!event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                break;
            }
            for (RewriteLifecycleListener listener : context.getRewriteLifecycleListeners()) {
                listener.afterOutboundRewrite((Rewrite)event);
            }
        }
        return event;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.lockStreams();
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.lockStreams();
        super.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.lockStreams();
        super.sendRedirect(location);
    }

    public void reset() {
        this.bufferedResponseContent.reset();
        super.reset();
    }

    public void resetBuffer() {
        this.bufferedResponseContent.reset();
        super.resetBuffer();
    }

    private class RewriteServletOutputStream
    extends ServletOutputStream {
        private OutputStream stream;

        public RewriteServletOutputStream(OutputStream outputStream) {
            this.stream = outputStream;
        }

        public void write(int b) {
            try {
                this.stream.write(b);
            }
            catch (IOException e) {
                throw new RewriteException("Error writing int to stream [" + this.stream + "]", (Throwable)e);
            }
        }

        public void write(byte[] bytes) throws IOException {
            this.stream.write(bytes);
        }

        public void write(byte[] bytes, int off, int len) {
            try {
                this.stream.write(bytes, off, len);
            }
            catch (IOException e) {
                throw new RewriteException("Error writing bytes to stream [" + this.stream + "] at offset [" + off + "] with length [" + len + "]", (Throwable)e);
            }
        }

        public String toString() {
            return this.stream.toString();
        }
    }
}

