/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.NonEnriching;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.servlet.DispatcherType;
import org.ocpsoft.rewrite.servlet.http.HttpRequestCycleWrapper;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteWrappedRequest;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteWrappedResponse;
import org.ocpsoft.rewrite.servlet.spi.DispatcherTypeProvider;
import org.ocpsoft.rewrite.servlet.spi.RequestParameterProvider;

public class HttpRewriteRequestCycleWrapper
extends HttpRequestCycleWrapper
implements NonEnriching {
    private volatile List<RequestParameterProvider> providers;
    private final List<DispatcherTypeProvider> dispatcherProviders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRewriteRequestCycleWrapper() {
        if (this.providers == null) {
            HttpRewriteRequestCycleWrapper httpRewriteRequestCycleWrapper = this;
            synchronized (httpRewriteRequestCycleWrapper) {
                if (this.providers == null) {
                    this.providers = Iterators.asList((Iterable)ServiceLoader.load(RequestParameterProvider.class));
                }
            }
        }
        this.dispatcherProviders = Iterators.asList((Iterator)ServiceLoader.loadTypesafe(DispatcherTypeProvider.class).iterator());
        Collections.sort(this.dispatcherProviders, new WeightedComparator());
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        Object result = request;
        if (HttpRewriteWrappedRequest.getCurrentInstance((ServletRequest)request) == null) {
            LinkedHashMap<String, String[]> additionalParams = new LinkedHashMap<String, String[]>();
            for (RequestParameterProvider provider : this.providers) {
                Map m = provider.getAdditionalParameters((ServletRequest)request, (ServletResponse)response);
                if (m == null) continue;
                additionalParams.putAll(m);
            }
            result = new HttpRewriteWrappedRequest(request, additionalParams);
        }
        return result;
    }

    public HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        Object result = response;
        if (HttpRewriteWrappedResponse.getCurrentInstance((ServletRequest)request) == null || this.getDispatcherType(request, servletContext) == DispatcherType.ERROR) {
            result = new HttpRewriteWrappedResponse(request, response, servletContext);
        }
        return result;
    }

    private DispatcherType getDispatcherType(HttpServletRequest request, ServletContext context) {
        for (DispatcherTypeProvider provider : this.dispatcherProviders) {
            DispatcherType dispatcherType = provider.getDispatcherType((ServletRequest)request, context);
            if (dispatcherType == null) continue;
            return dispatcherType;
        }
        throw new IllegalStateException("Unable to determine dispatcher type of current request");
    }

    public int priority() {
        return 0;
    }
}

