/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.solder.beanManager.BeanManagerAware;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.logging.Logger;

public class CdiServiceEnricher
extends BeanManagerAware
implements ServiceEnricher {
    Logger log = Logger.getLogger(CdiServiceEnricher.class);

    public <T> Collection<T> produce(Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        BeanManager manager = this.getBeanManager();
        Set beans = manager.getBeans(type, new Annotation[0]);
        for (Bean bean : beans) {
            CreationalContext context;
            if (bean == null || (context = manager.createCreationalContext((Contextual)bean)) == null) continue;
            result.add(manager.getReference(bean, type, context));
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Created CDI enriched service [" + bean.toString() + "]");
        }
        return result;
    }

    public <T> void enrich(T service) {
        if (service != null) {
            BeanManager manager = this.getBeanManager();
            CreationalContext context = manager.createCreationalContext(null);
            InjectionTarget injectionTarget = manager.createInjectionTarget(manager.createAnnotatedType(service.getClass()));
            injectionTarget.inject(service, context);
            if (context != null && this.log.isDebugEnabled()) {
                this.log.debug("Enriched non-contextual intance of service [" + service.getClass().getName() + "]");
            }
        }
    }
}

