/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi.expressions;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.inject.Inject;
import org.ocpsoft.rewrite.cdi.util.Reflections;

public class Expressions {
    private final ELContext context;
    private final ExpressionFactory expressionFactory;

    @Inject
    public Expressions(ELContext context, ExpressionFactory expressionFactory) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (expressionFactory == null) {
            throw new IllegalArgumentException("expressionFactory must not be null");
        }
        this.context = context;
        this.expressionFactory = expressionFactory;
    }

    public ELContext getELContext() {
        return this.context;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public <T> T evaluateValueExpression(String expression, Class<T> expectedType) {
        Object result = this.expressionFactory.createValueExpression(this.context, expression, expectedType).getValue(this.context);
        if (result != null) {
            return expectedType.cast(result);
        }
        return null;
    }

    public <T> T evaluateValueExpression(String expression) {
        Object result = this.evaluateValueExpression(expression, Object.class);
        if (result != null) {
            return Reflections.cast(result);
        }
        return null;
    }

    public <T> T evaluateMethodExpression(String expression, Class<T> expectedReturnType, Object[] params, Class<?>[] expectedParamTypes) {
        Object result = this.expressionFactory.createMethodExpression(this.context, expression, expectedReturnType, (Class[])expectedParamTypes).invoke(this.context, params);
        if (result != null) {
            return expectedReturnType.cast(result);
        }
        return null;
    }

    public <T> T evaluateMethodExpression(String expression, Class<T> expectedReturnType) {
        return this.evaluateMethodExpression(expression, expectedReturnType, new Object[0], new Class[0]);
    }

    public <T> T evaluateMethodExpression(String expression) {
        Object result = this.evaluateMethodExpression(expression, Object.class);
        if (result != null) {
            return Reflections.cast(result);
        }
        return null;
    }

    public <T> T evaluateMethodExpression(String expression, Object ... params) {
        Object result = this.evaluateMethodExpression(expression, Object.class, params, new Class[params.length]);
        if (result != null) {
            return Reflections.cast(result);
        }
        return null;
    }

    public String toExpression(String name) {
        return "#{" + name + "}";
    }
}

