/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import org.ocpsoft.rewrite.cdi.expressions.Expressions;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;

public class CdiExpressionLanguageProvider
implements ExpressionLanguageProvider {
    @Inject
    private Instance<Expressions> expressionsInstance;

    public int priority() {
        return 10;
    }

    public Object retrieveValue(String expression) {
        Expressions expressions = (Expressions)this.expressionsInstance.get();
        return this.getValue(expressions.getELContext(), expressions.getExpressionFactory(), this.groomExpression(expression));
    }

    public void submitValue(String expression, Object value) {
        Expressions expressions = (Expressions)this.expressionsInstance.get();
        String el = this.groomExpression(expression);
        if (this.getExpectedType(expressions.getELContext(), expressions.getExpressionFactory(), el).isArray()) {
            Object[] toInject = null;
            toInject = value != null && !value.getClass().isArray() ? new Object[]{value} : (Object[])value;
            this.setValue(expressions.getELContext(), expressions.getExpressionFactory(), el, toInject);
        } else {
            Object toInject = value;
            if (value != null && value.getClass().isArray()) {
                Object[] array = (Object[])value;
                toInject = array.length > 0 ? array[0] : "";
            }
            this.setValue(expressions.getELContext(), expressions.getExpressionFactory(), el, toInject);
        }
    }

    public String groomExpression(String expression) {
        String result = expression.trim();
        if (!result.startsWith("#{")) {
            return ((Expressions)this.expressionsInstance.get()).toExpression(result);
        }
        return result;
    }

    public Object evaluateMethodExpression(String expression) {
        String el = this.groomExpression(expression);
        return ((Expressions)this.expressionsInstance.get()).evaluateMethodExpression(el);
    }

    public Object evaluateMethodExpression(String expression, Object ... values) {
        String el = this.groomExpression(expression);
        return ((Expressions)this.expressionsInstance.get()).evaluateMethodExpression(el, values);
    }

    private Class<?> getExpectedType(ELContext context, ExpressionFactory factory, String expression) throws ELException {
        ValueExpression ve = factory.createValueExpression(context, expression, Object.class);
        return ve.getType(context);
    }

    private Object getValue(ELContext context, ExpressionFactory factory, String expression) throws ELException {
        ValueExpression ve = factory.createValueExpression(context, expression, Object.class);
        return ve.getValue(context);
    }

    private void setValue(ELContext context, ExpressionFactory factory, String expression, Object value) throws ELException {
        ValueExpression ve = factory.createValueExpression(context, expression, Object.class);
        ve.setValue(context, factory.coerceToType(value, ve.getType(context)));
    }
}

