/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi.expressions;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ocpsoft.rewrite.cdi.expressions.Composite;
import org.ocpsoft.rewrite.cdi.expressions.Resolver;
import org.ocpsoft.rewrite.cdi.expressions.ResolverLiteral;

public class ELResolverProducer {
    @Produces
    @Composite
    public ELResolver getELResolver(@Resolver Instance<ELResolver> resolvers, BeanManager beanManager) {
        boolean isGlassFish;
        CompositeELResolver compositeResolver = new CompositeELResolver();
        compositeResolver.add(beanManager.getELResolver());
        compositeResolver.add((ELResolver)new MapELResolver());
        compositeResolver.add((ELResolver)new ListELResolver());
        compositeResolver.add((ELResolver)new ArrayELResolver());
        compositeResolver.add((ELResolver)new ResourceBundleELResolver());
        compositeResolver.add((ELResolver)new BeanELResolver());
        boolean bl = isGlassFish = System.getProperty("glassfish.version") != null;
        if (isGlassFish) {
            for (ELResolver resolver : this.getReferences(beanManager, ELResolver.class, new ResolverLiteral())) {
                compositeResolver.add(resolver);
            }
        } else {
            for (ELResolver resolver : resolvers) {
                compositeResolver.add(resolver);
            }
        }
        return compositeResolver;
    }

    private <T> Set<T> getReferences(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        Set resolverBeans = manager.getBeans(type, qualifiers);
        if (resolverBeans.size() == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<Object> refs = new LinkedHashSet<Object>();
        for (Bean bean : resolverBeans) {
            CreationalContext context = manager.createCreationalContext((Contextual)bean);
            if (context == null) continue;
            refs.add(manager.getReference(bean, type, context));
        }
        return refs;
    }
}

