/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi.manager;

import jakarta.enterprise.inject.spi.BeanManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.rewrite.cdi.manager.BeanManagerUnavailableException;
import org.ocpsoft.rewrite.cdi.spi.BeanManagerProvider;

public class BeanManagerLocator {
    private volatile BeanManager beanManager;
    private volatile boolean lookupPerformed = false;
    private volatile BeanManagerProvider locatingProvider;
    private volatile List<BeanManagerProvider> providers;

    public BeanManager getBeanManager() {
        if (!this.lookupPerformed) {
            this.lookupBeanManager();
        }
        if (this.beanManager == null) {
            throw new BeanManagerUnavailableException(this.providers);
        }
        return this.beanManager;
    }

    public boolean isBeanManagerAvailable() {
        if (!this.lookupPerformed) {
            this.lookupBeanManager();
        }
        return this.beanManager != null;
    }

    public BeanManagerProvider getLocatingProvider() {
        return this.locatingProvider;
    }

    private synchronized void lookupBeanManager() {
        if (!this.lookupPerformed) {
            List<BeanManagerProvider> providers = this.loadServices();
            Collections.sort(providers, new WeightedComparator());
            for (BeanManagerProvider provider : providers) {
                this.beanManager = provider.getBeanManager();
                if (this.beanManager == null) continue;
                this.locatingProvider = provider;
                break;
            }
            this.providers = providers;
            this.lookupPerformed = true;
        }
    }

    private List<BeanManagerProvider> loadServices() {
        ArrayList<BeanManagerProvider> providers = new ArrayList<BeanManagerProvider>();
        Iterator<BeanManagerProvider> it = ServiceLoader.load(BeanManagerProvider.class).iterator();
        while (it.hasNext()) {
            providers.add(it.next());
        }
        return providers;
    }
}

