/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi.manager;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.lang.annotation.Annotation;

public abstract class BeanManagerUtils {
    public static <T> T getContextualInstance(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        CreationalContext context;
        Object result = null;
        Bean bean = manager.resolve(manager.getBeans(type, qualifiers));
        if (bean != null && (context = manager.createCreationalContext((Contextual)bean)) != null) {
            result = manager.getReference(bean, type, context);
        }
        return (T)result;
    }

    public static CreationalContext<Object> injectNonContextualInstance(BeanManager manager, Object instance) {
        if (instance != null) {
            CreationalContext creationalContext = manager.createCreationalContext(null);
            InjectionTarget injectionTarget = manager.createInjectionTarget(manager.createAnnotatedType(instance.getClass()));
            injectionTarget.inject(instance, creationalContext);
            return creationalContext;
        }
        return null;
    }
}

