/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;

public class CdiBeanNameResolver
implements BeanNameResolver {
    private final Logger log = Logger.getLogger(CdiBeanNameResolver.class);
    @Inject
    private BeanManager beanManager;

    public String getBeanName(Class<?> clazz) {
        Set beans = this.beanManager.getBeans(clazz, new Annotation[0]);
        if (beans == null || beans.size() == 0) {
            return null;
        }
        if (beans.size() > 1) {
            this.log.warn("The BeanManager returns more than one name for [{}]", (Object)clazz.getName());
            return null;
        }
        return ((Bean)beans.iterator().next()).getName();
    }
}

