/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.ocpsoft.common.spi.ServiceLocator;
import org.ocpsoft.rewrite.cdi.manager.BeanManagerAware;
import org.ocpsoft.rewrite.cdi.util.ParameterizedTypeImpl;
import org.ocpsoft.rewrite.cdi.util.WildcardTypeImpl;

public class CdiServiceLocator
extends BeanManagerAware
implements ServiceLocator {
    public <T> Collection<Class<T>> locate(Class<T> type) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        if (this.isBeanManagerAvailable()) {
            BeanManager manager = this.getBeanManager();
            Set beans = manager.getBeans(this.getRequiredType(type), new Annotation[]{new AnnotationLiteral<Any>(){
                private static final long serialVersionUID = -1896831901770051851L;
            }});
            for (Bean bean : beans) {
                result.add(bean.getBeanClass());
            }
        }
        return result;
    }

    private Type getRequiredType(Class<?> clazz) {
        TypeVariable<Class<?>>[] typeParameters = clazz.getTypeParameters();
        if (typeParameters.length > 0) {
            Type[] actualTypeParameters = new Type[typeParameters.length];
            for (int i = 0; i < typeParameters.length; ++i) {
                actualTypeParameters[i] = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
            }
            return new ParameterizedTypeImpl(clazz, actualTypeParameters, null);
        }
        return clazz;
    }
}

