/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.faces.FacesRewriteLifecycleListener;

public class RewriteNavigationHandler
extends ConfigurableNavigationHandler {
    private static final String REWRITE_PREFIX = "rewrite:";
    private static final String IN_NAVIGATION = RewriteNavigationHandler.class.getName() + "_inNavigation";
    private final ConfigurableNavigationHandler parent;

    public RewriteNavigationHandler(ConfigurableNavigationHandler parent) {
        this.parent = parent;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (!this.redirect(context, outcome)) {
            this.setInNavigation((HttpServletRequest)context.getExternalContext().getRequest(), true);
            String originalViewId = context.getViewRoot().getViewId();
            this.parent.handleNavigation(context, fromAction, outcome);
            String newViewId = context.getViewRoot().getViewId();
            if (context.getResponseComplete() || originalViewId.equals(newViewId)) {
                this.setInNavigation((HttpServletRequest)context.getExternalContext().getRequest(), false);
            }
        }
    }

    private void setInNavigation(HttpServletRequest request, boolean inNavigation) {
        request.setAttribute(IN_NAVIGATION, (Object)inNavigation);
    }

    public static boolean isInNavigation(HttpServletRequest request) {
        Boolean inNavigation = (Boolean)request.getAttribute(IN_NAVIGATION);
        return inNavigation == null ? false : inNavigation;
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (REWRITE_PREFIX.equals(outcome)) {
            String viewId = context.getViewRoot().getViewId();
            NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, viewId);
            return navigationCase;
        }
        NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, outcome);
        return navigationCase;
    }

    private boolean redirect(FacesContext context, String outcome) {
        ExternalContext externalContext = context.getExternalContext();
        if (REWRITE_PREFIX.equals(outcome)) {
            String target = FacesRewriteLifecycleListener.getOriginalRequestURL((HttpServletRequest)externalContext.getRequest());
            String redirectUrl = externalContext.encodeRedirectURL(target, null);
            try {
                externalContext.redirect(redirectUrl);
                return true;
            }
            catch (IOException e) {
                throw new RewriteException("Could not redirect to [" + redirectUrl + "]", (Throwable)e);
            }
        }
        return false;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.parent.getNavigationCases();
    }

    public void performNavigation(String outcome) {
        this.parent.performNavigation(outcome);
    }
}

