/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.pattern.Weighted;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class PhaseOperation<T extends PhaseOperation<T>>
extends HttpOperation
implements Weighted {
    private static final String REQUEST_KEY = PhaseOperation.class.getName() + "_DEFERRED";
    private HttpServletRewrite event;
    private EvaluationContext context;
    private final Set<PhaseId> beforePhases = new HashSet<PhaseId>();
    private final Set<PhaseId> afterPhases = new HashSet<PhaseId>();

    public abstract void performOperation(HttpServletRewrite var1, EvaluationContext var2);

    public Set<PhaseId> getBeforePhases() {
        return this.beforePhases;
    }

    public Set<PhaseId> getAfterPhases() {
        return this.afterPhases;
    }

    public OperationBuilder before(PhaseId ... phases) {
        if (phases != null) {
            this.beforePhases.addAll(Arrays.asList(phases));
        }
        return this;
    }

    public OperationBuilder after(PhaseId ... phases) {
        if (phases != null) {
            this.afterPhases.addAll(Arrays.asList(phases));
        }
        return this;
    }

    public final void performHttp(HttpServletRewrite event, EvaluationContext context) {
        this.event = event;
        this.context = context;
        PhaseOperation.getSortedPhaseOperations((HttpServletRequest)event.getRequest()).add(this);
    }

    public static ArrayList<PhaseOperation<?>> getSortedPhaseOperations(HttpServletRequest request) {
        ArrayList operations = (ArrayList)request.getAttribute(REQUEST_KEY);
        if (operations == null) {
            operations = new ArrayList();
            request.setAttribute(REQUEST_KEY, operations);
        }
        Collections.sort(operations, new WeightedComparator());
        return operations;
    }

    public HttpServletRewrite getEvent() {
        return this.event;
    }

    public EvaluationContext getContext() {
        return this.context;
    }

    public static PhaseOperation<?> enqueue(Operation operation) {
        return PhaseOperation.enqueue(operation, 0);
    }

    public static PhaseOperation<?> enqueue(final Operation operation, final int priority) {
        return new PhaseOperation(){

            public int priority() {
                return priority;
            }

            @Override
            public void performOperation(HttpServletRewrite event, EvaluationContext context) {
                operation.perform((Rewrite)event, context);
            }
        };
    }
}

