/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.navigate;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.faces.navigate.ParameterMap;
import org.ocpsoft.rewrite.servlet.spi.ResourcePathResolver;

public class Navigate {
    private final String viewId;
    private final ParameterMap parameters = new ParameterMap();
    private boolean redirect = true;

    private Navigate(String viewId) {
        this.viewId = viewId;
    }

    public static Navigate to(String viewId) {
        Assert.notNull((Object)viewId, (String)"viewId must not be null");
        return new Navigate(viewId);
    }

    public static Navigate to(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ServiceLoader resolvers = ServiceLoader.load(ResourcePathResolver.class);
        for (ResourcePathResolver resolver : resolvers) {
            String viewId = resolver.resolveFrom(clazz);
            if (viewId == null) continue;
            return new Navigate(viewId);
        }
        throw new IllegalArgumentException("Unable to find the resource path for: " + clazz.getName());
    }

    public Navigate with(CharSequence name, Object value) {
        Assert.notNull((Object)name, (String)"name must not be null");
        if (value != null) {
            this.parameters.put(((Object)name).toString(), value.toString());
        }
        return this;
    }

    public Navigate withoutRedirect() {
        this.redirect = false;
        return this;
    }

    public String build() {
        ParameterMap query = this.parameters.copy();
        if (this.redirect) {
            query.put("faces-redirect", "true");
        }
        StringBuilder outcome = new StringBuilder();
        outcome.append(this.viewId);
        boolean first = true;
        for (Map.Entry<String, List<String>> param : query.entrySet()) {
            for (String value : param.getValue()) {
                outcome.append(first ? (char)'?' : '&');
                outcome.append(Navigate.encodeQuery(param.getKey()));
                outcome.append('=');
                outcome.append(Navigate.encodeQuery(value));
                first = false;
            }
        }
        return outcome.toString();
    }

    private static String encodeQuery(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.build();
    }
}

