/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.config;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.faces.util.NullComponent;

public class FacesConverter<T>
implements Converter<T> {
    private final Class<?> targetType;
    private final String converterId;

    private FacesConverter(String converterId, Class<?> targetType) {
        this.converterId = converterId;
        this.targetType = targetType;
    }

    public static <T> FacesConverter<T> forType(Class<?> targetType) {
        return new FacesConverter<T>(null, targetType);
    }

    public static <T> FacesConverter<T> forId(String converterId) {
        return new FacesConverter<T>(converterId, null);
    }

    public T convert(Rewrite event, EvaluationContext context, Object value) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Assert.notNull((Object)facesContext, (String)"FacesContext.getCurrentInstance() returned null. You should use @Deferred so the binding gets executed within the JSF lifecycle.");
        javax.faces.convert.Converter converter = null;
        if (this.converterId != null) {
            converter = facesContext.getApplication().createConverter(this.converterId);
            Assert.notNull((Object)converter, (String)("Could not create JSF converter for ID: " + this.converterId));
        } else {
            converter = facesContext.getApplication().createConverter(this.targetType);
            Assert.notNull((Object)converter, (String)("Could not create JSF converter for type: " + this.targetType.getName()));
        }
        String valueAsString = value != null ? value.toString() : null;
        try {
            return (T)converter.getAsObject(facesContext, (UIComponent)new NullComponent(), valueAsString);
        }
        catch (ConverterException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FacesConverterAdapter[");
        if (this.converterId != null) {
            builder.append("converterId=");
            builder.append(this.converterId);
        } else {
            builder.append("targetType=");
            builder.append(this.targetType.getName().toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

