/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.faces.FacesRewriteLifecycleListener;
import org.ocpsoft.urlbuilder.AddressBuilder;

public class RewriteNavigationHandler
extends ConfigurableNavigationHandler {
    private static final String REWRITE_PREFIX = "rewrite:";
    public static final String REDIRECT_PREFIX = "rewrite-redirect:";
    private static final String IN_NAVIGATION = RewriteNavigationHandler.class.getName() + "_inNavigation";
    private final ConfigurableNavigationHandler parent;

    public RewriteNavigationHandler(ConfigurableNavigationHandler parent) {
        this.parent = parent;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (!this.redirect(context, outcome)) {
            this.setInNavigation((HttpServletRequest)context.getExternalContext().getRequest(), true);
            String originalViewId = null;
            if (context.getViewRoot() != null) {
                originalViewId = context.getViewRoot().getViewId();
            }
            this.parent.handleNavigation(context, fromAction, outcome);
            String newViewId = null;
            if (context.getViewRoot() != null) {
                newViewId = context.getViewRoot().getViewId();
            }
            if (context.getResponseComplete() || originalViewId == newViewId || originalViewId != null && originalViewId.equals(newViewId)) {
                this.setInNavigation((HttpServletRequest)context.getExternalContext().getRequest(), false);
            }
        }
    }

    private void setInNavigation(HttpServletRequest request, boolean inNavigation) {
        request.setAttribute(IN_NAVIGATION, (Object)inNavigation);
    }

    public static boolean isInNavigation(HttpServletRequest request) {
        Boolean inNavigation = (Boolean)request.getAttribute(IN_NAVIGATION);
        return inNavigation == null ? false : inNavigation;
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (REWRITE_PREFIX.equals(outcome)) {
            String viewId = context.getViewRoot().getViewId();
            NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, viewId);
            return navigationCase;
        }
        if (outcome != null && outcome.startsWith(REDIRECT_PREFIX)) {
            String url = outcome.substring(REDIRECT_PREFIX.length());
            String viewId = AddressBuilder.create((String)url).getPath();
            return this.parent.getNavigationCase(context, fromAction, viewId);
        }
        NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, outcome);
        return navigationCase;
    }

    private boolean redirect(FacesContext context, String outcome) {
        ExternalContext externalContext = context.getExternalContext();
        if (REWRITE_PREFIX.equals(outcome)) {
            String target = FacesRewriteLifecycleListener.getOriginalRequestURL((HttpServletRequest)externalContext.getRequest());
            String redirectUrl = externalContext.encodeRedirectURL(target, null);
            try {
                externalContext.redirect(redirectUrl);
                return true;
            }
            catch (IOException e) {
                throw new RewriteException("Could not redirect to [" + redirectUrl + "]", (Throwable)e);
            }
        }
        if (outcome != null && outcome.startsWith(REDIRECT_PREFIX)) {
            String relativeUrl = outcome.substring(REDIRECT_PREFIX.length());
            String absoluteUrl = this.prependContextPath(externalContext, relativeUrl);
            String rewrittenUrl = externalContext.encodeActionURL(absoluteUrl);
            try {
                externalContext.redirect(rewrittenUrl);
                return true;
            }
            catch (IOException e) {
                throw new RewriteException("Could not redirect to [" + rewrittenUrl + "]", (Throwable)e);
            }
        }
        return false;
    }

    private String prependContextPath(ExternalContext externalContext, String url) {
        String contextPath = externalContext.getRequestContextPath();
        if ("/".equals(contextPath) || url.startsWith(contextPath)) {
            return url;
        }
        return contextPath + url;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.parent.getNavigationCases();
    }

    public void performNavigation(String outcome) {
        this.parent.performNavigation(outcome);
    }
}

