/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.spring;

import org.ocpsoft.rewrite.exception.UnsupportedEvaluationException;
import org.ocpsoft.rewrite.spi.ExpressionLanguageProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.web.context.WebApplicationContext;

public class SpringExpressionLanguageProvider
implements ExpressionLanguageProvider {
    private final ExpressionParser parser = new SpelExpressionParser();
    @Autowired
    private WebApplicationContext applicationContext;
    private EvaluationContext _evaluationContext = null;

    public Object retrieveValue(String expression) throws UnsupportedEvaluationException {
        try {
            Expression exp = this.parser.parseExpression(expression);
            return exp.getValue(this.getEvaluationContext());
        }
        catch (SpelEvaluationException e) {
            throw new UnsupportedEvaluationException((Throwable)e);
        }
    }

    public void submitValue(String expression, Object value) throws UnsupportedEvaluationException {
        try {
            Expression exp = this.parser.parseExpression(expression);
            exp.setValue(this.getEvaluationContext(), value);
        }
        catch (SpelEvaluationException e) {
            throw new UnsupportedEvaluationException((Throwable)e);
        }
    }

    public Object evaluateMethodExpression(String expression) throws UnsupportedEvaluationException {
        try {
            Expression exp = this.parser.parseExpression(expression);
            return exp.getValue(this.getEvaluationContext());
        }
        catch (SpelEvaluationException e) {
            throw new UnsupportedEvaluationException((Throwable)e);
        }
    }

    public Object evaluateMethodExpression(String expression, Object ... values) throws UnsupportedEvaluationException {
        throw new UnsupportedEvaluationException();
    }

    public EvaluationContext getEvaluationContext() {
        if (this._evaluationContext == null) {
            ConfigurableBeanFactory beanFactory = null;
            if (this.applicationContext instanceof ConfigurableBeanFactory) {
                beanFactory = (ConfigurableBeanFactory)this.applicationContext;
            }
            if (beanFactory == null && this.applicationContext != null && this.applicationContext.getAutowireCapableBeanFactory() instanceof ConfigurableBeanFactory) {
                beanFactory = (ConfigurableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
            }
            if (beanFactory == null) {
                throw new IllegalStateException("Unable to find a ConfigurableBeanFactory");
            }
            BeanExpressionContext beanEvaluationContext = new BeanExpressionContext(beanFactory, null);
            StandardEvaluationContext sec = new StandardEvaluationContext();
            sec.setRootObject((Object)beanEvaluationContext);
            sec.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
            sec.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
            sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            sec.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)beanEvaluationContext.getBeanFactory()));
            sec.setTypeLocator((TypeLocator)new StandardTypeLocator(beanEvaluationContext.getBeanFactory().getBeanClassLoader()));
            ConversionService conversionService = beanEvaluationContext.getBeanFactory().getConversionService();
            if (conversionService != null) {
                sec.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
            }
            this._evaluationContext = sec;
        }
        return this._evaluationContext;
    }
}

