/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.spring;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.spring.SpringServletContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class SpringServiceEnricher
implements ServiceEnricher {
    private final Logger log = Logger.getLogger(SpringServiceEnricher.class);

    public <T> void enrich(T service) {
        ServletContext context = SpringServletContextLoader.findCurrentServletContext();
        if (context != null) {
            SpringBeanAutowiringSupport.processInjectionBasedOnServletContext(service, (ServletContext)context);
        } else {
            SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(service);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Enriched instance of service [" + service.getClass().getName() + "]");
        }
    }

    public <T> Collection<T> produce(Class<T> type) {
        WebApplicationContext webApplicationContext = SpringServletContextLoader.findCurrentApplicationContext();
        if (webApplicationContext == null) {
            return new ArrayList();
        }
        return webApplicationContext.getBeanProvider(type).stream().collect(Collectors.toList());
    }
}

