/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.security.shiro;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shiro.SecurityUtils;
import org.ocpsoft.rewrite.annotation.api.ClassContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.security.shiro.ShiroRoleRequired;

public class ShiroRoleRequiredHandler
implements AnnotationHandler<ShiroRoleRequired> {
    public Class<ShiroRoleRequired> handles() {
        return ShiroRoleRequired.class;
    }

    public int priority() {
        return 200;
    }

    public void process(ClassContext context, ShiroRoleRequired annotation, HandlerChain chain) {
        ShiroRoleCondition roleCondition = new ShiroRoleCondition(annotation.value());
        ConditionBuilder conjunction = context.getRuleBuilder().getConditionBuilder().and((Condition)roleCondition);
        context.getRuleBuilder().when((Condition)conjunction);
        chain.proceed();
    }

    private static class ShiroRoleCondition
    implements Condition {
        private final Collection<String> roles;

        public ShiroRoleCondition(String[] roles) {
            this.roles = Arrays.asList(roles);
        }

        public boolean evaluate(Rewrite event, EvaluationContext context) {
            return SecurityUtils.getSubject().hasAllRoles(this.roles);
        }
    }
}

