/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class Evaluation
extends BindingBuilder {
    private final CharSequence property;

    private Evaluation(CharSequence property) {
        this.property = property;
    }

    public static BindingBuilder property(CharSequence property) {
        return new Evaluation(property);
    }

    public static BindingBuilder property(CharSequence property, Class<? extends Converter<?>> type) {
        return Evaluation.property(property).convertedBy((Class)type);
    }

    public static BindingBuilder property(CharSequence property, Class<Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        return Evaluation.property(property, converterType).validatedBy((Class)validatorType);
    }

    @Override
    public Object submit(Rewrite event, EvaluationContext context, Object value) {
        if (!context.containsKey(this.property)) {
            if (value.getClass().isArray()) {
                context.put(this.getParameterName(this.property), value);
            } else {
                context.put(this.getParameterName(this.property), new Object[]{value});
            }
        } else {
            Object[] values = (Object[])context.get(this.getParameterName(this.property));
            List<Object> list = Arrays.asList(values);
            if (value.getClass().isArray()) {
                list.addAll(Arrays.asList((Object[])value));
            } else {
                list.add(value);
            }
            context.put(this.getParameterName(this.property), list.toArray());
        }
        return null;
    }

    private String getParameterName(CharSequence parameter) {
        return Evaluation.class.getName() + parameter;
    }

    @Override
    public Object retrieve(Rewrite event, EvaluationContext context) {
        Object[] array;
        Object object = context.get(this.getParameterName(this.property));
        if (object.getClass().isArray() && (array = (Object[])object).length == 1) {
            return array[0];
        }
        return object;
    }

    @Override
    public boolean supportsRetrieval() {
        return true;
    }

    @Override
    public boolean supportsSubmission() {
        return true;
    }

    public String toString() {
        return "Evaluation [property=" + this.property + "]";
    }
}

