/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexParameter;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Header
extends HttpCondition {
    private final ParameterizedPattern name;
    private final ParameterizedPattern value;

    private Header(String name, String value) {
        Assert.notNull(name, "Header name pattern cannot be null.");
        Assert.notNull(value, "Header value pattern cannot be null.");
        this.name = new ParameterizedPattern(name);
        this.value = new ParameterizedPattern(value);
    }

    public static Header matches(String name, String value) {
        return new Header(name, value);
    }

    public static Header exists(String name) {
        return new Header(name, ".*");
    }

    public static Header valueExists(String value) {
        return new Header(".*", value);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String header : Collections.list(request.getHeaderNames())) {
            if (!this.name.matches(event, context, header) || !this.matchesValue(event, context, request, header)) continue;
            Map<RegexParameter, String[]> parameters = this.name.parse(event, context, header);
            parameters = this.value.parse(event, context, header);
            if (!Bindings.enqueuePreOperationSubmissions(event, context, parameters) || !Bindings.enqueuePreOperationSubmissions(event, context, parameters)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Collections.list(request.getHeaders(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }
}

