/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexConditionParameterBuilder;
import org.ocpsoft.rewrite.bind.RegexParameter;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ConditionParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterizedCondition;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class Scheme
extends HttpCondition
implements ParameterizedCondition<ConditionParameterBuilder<RegexConditionParameterBuilder, String>, String> {
    private final ParameterizedPattern expression;

    private Scheme(String pattern) {
        Assert.notNull(pattern, "Scheme must not be null.");
        this.expression = new ParameterizedPattern(pattern);
        for (RegexParameter parameter : this.expression.getParameters().values()) {
            parameter.bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Scheme matches(String pattern) {
        return new Scheme(pattern);
    }

    @Override
    public RegexConditionParameterBuilder where(String param) {
        return new RegexConditionParameterBuilder(this, this.expression.getParameter(param));
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param).bindsTo(binding);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        Map<RegexParameter, String[]> parameters;
        String scheme = null;
        if (event instanceof HttpOutboundServletRewrite) {
            String url = event.getURL();
            URLBuilder builder = URLBuilder.createFrom(url);
            scheme = builder.toURI().getScheme();
            if (scheme == null) {
                scheme = ((HttpServletRequest)event.getRequest()).getScheme();
            }
        } else {
            scheme = ((HttpServletRequest)event.getRequest()).getScheme();
        }
        return scheme != null && this.expression.matches(event, context, scheme) && Bindings.enqueuePreOperationSubmissions(event, context, parameters = this.expression.parse(event, context, scheme));
    }

    public ParameterizedPattern getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }
}

