/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexConditionParameterBuilder;
import org.ocpsoft.rewrite.bind.RegexParameter;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ConditionParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterizedCondition;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Path
extends HttpCondition
implements ParameterizedCondition<ConditionParameterBuilder<RegexConditionParameterBuilder, String>, String> {
    private final ParameterizedPattern expression;

    private Path(String pattern) {
        Assert.notNull(pattern, "Path must not be null.");
        this.expression = new ParameterizedPattern("[^/]+", pattern);
        for (RegexParameter parameter : this.expression.getParameters().values()) {
            parameter.bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Path matches(String pattern) {
        return new Path(pattern);
    }

    public static Path captureIn(String param) {
        Path path = new Path("{" + param + "}");
        path.where(param).matches(".*");
        return path;
    }

    public Path withRequestBinding() {
        for (RegexParameter parameter : this.expression.getParameters().values()) {
            parameter.bindsTo(Request.parameter(parameter.getName()));
        }
        return this;
    }

    @Override
    public RegexConditionParameterBuilder where(String param) {
        return new RegexConditionParameterBuilder(this, this.expression.getParameter(param));
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param).bindsTo(binding);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        Map<RegexParameter, String[]> parameters;
        String requestURL = null;
        if (event instanceof HttpOutboundServletRewrite) {
            requestURL = ((HttpOutboundServletRewrite)event).getOutboundURL().split("\\?")[0];
            if (requestURL.startsWith(event.getContextPath())) {
                requestURL = requestURL.substring(event.getContextPath().length());
            }
        } else {
            requestURL = event.getRequestPath();
        }
        return this.expression.matches(event, context, requestURL) && Bindings.enqueuePreOperationSubmissions(event, context, parameters = this.expression.parse(event, context, requestURL));
    }

    public ParameterizedPattern getPathExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }
}

