/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Collections;
import java.util.List;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.config.Rule;

public class ConfigurationLoader {
    public static Logger log = Logger.getLogger(ConfigurationLoader.class);

    public static Configuration loadConfiguration(Object context) {
        ServiceLoader loader = ServiceLoader.load(ConfigurationProvider.class);
        List<ConfigurationProvider> providers = Iterators.asList(loader.iterator());
        Collections.sort(providers, new WeightedComparator());
        ConfigurationBuilder result = ConfigurationBuilder.begin();
        for (ConfigurationProvider provider : providers) {
            if (!provider.handles(context)) continue;
            Configuration configuration = provider.getConfiguration(context);
            if (configuration != null) {
                List<Rule> rules = configuration.getRules();
                if (rules != null) {
                    for (Rule rule : rules) {
                        if (rule != null) {
                            result.addRule(rule);
                            continue;
                        }
                        log.debug("Ignoring null Rule from ConfigurationProvider [" + provider.getClass().getName() + "]");
                    }
                    continue;
                }
                log.debug("Ignoring null List<Rule> from ConfigurationProvider [" + provider.getClass().getName() + "]");
                continue;
            }
            log.debug("Ignoring null Configuration from ConfigurationProvider [" + provider.getClass().getName() + "].");
        }
        return result;
    }
}

