/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.net.MalformedURLException;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Resource
extends HttpCondition {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final ParameterizedPattern resource;

    private Resource(String resource) {
        this.resource = new ParameterizedPattern(resource);
        for (ParameterizedPattern.RegexParameter parameter : this.resource.getParameters().values()) {
            parameter.bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null) {
            String file = this.resource.build(event, context);
            try {
                return ((HttpServletRequest)event.getRequest()).getServletContext().getResource(file) != null;
            }
            catch (MalformedURLException e) {
                log.debug("Invalid file format [{}]", file);
            }
        }
        return false;
    }

    public static Resource exists(String resource) {
        return new Resource(resource);
    }
}

