/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.config.RelocatableRule;
import org.ocpsoft.rewrite.config.Rule;

public class ConfigurationLoader {
    public static Logger log = Logger.getLogger(ConfigurationLoader.class);

    public static Configuration loadConfiguration(Object context) {
        ServiceLoader loader = ServiceLoader.load(ConfigurationProvider.class);
        List<ConfigurationProvider> providers = Iterators.asList(loader.iterator());
        HashMap priorityMap = new HashMap();
        Collections.sort(providers, new WeightedComparator());
        for (ConfigurationProvider provider : providers) {
            if (!provider.handles(context)) continue;
            Configuration configuration = provider.getConfiguration(context);
            if (configuration != null) {
                List<Rule> rules = configuration.getRules();
                if (rules != null) {
                    for (Rule rule : rules) {
                        if (rule != null) {
                            if (rule instanceof RelocatableRule) {
                                ConfigurationLoader.addListValue(priorityMap, ((RelocatableRule)rule).priority(), rule);
                                continue;
                            }
                            ConfigurationLoader.addListValue(priorityMap, provider.priority(), rule);
                            continue;
                        }
                        log.debug("Ignoring null Rule from ConfigurationProvider [" + provider.getClass().getName() + "]");
                    }
                    continue;
                }
                log.debug("Ignoring null List<Rule> from ConfigurationProvider [" + provider.getClass().getName() + "]");
                continue;
            }
            log.debug("Ignoring null Configuration from ConfigurationProvider [" + provider.getClass().getName() + "].");
        }
        ConfigurationBuilder result = ConfigurationBuilder.begin();
        ArrayList sortedKeys = new ArrayList(priorityMap.keySet());
        Collections.sort(sortedKeys);
        for (Integer integer : sortedKeys) {
            List list = (List)priorityMap.get(integer);
            for (Rule rule : list) {
                result.addRule(rule);
            }
        }
        return result;
    }

    public static <K, T> void addListValue(Map<K, List<T>> map, K key, T value) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList<Object>(Arrays.asList(value)));
        } else {
            map.get(key).add(value);
        }
    }
}

