/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.bind.parse.CaptureType;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.IForward;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class Forward
extends HttpOperation
implements IForward {
    private final ParameterizedPattern location;
    private final ParameterStore<IForward.ForwardParameter> parameters = new ParameterStore();

    private Forward(String location) {
        Assert.notNull(location, "Location must not be null.");
        this.location = new ParameterizedPattern(CaptureType.BRACE, "[^/]+", location);
        for (RegexCapture parameter : this.location.getParameters().values()) {
            this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Forward to(String location) {
        return new Forward(location);
    }

    @Override
    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build(event, context, this.parameters.getParameters());
            ((HttpInboundServletRewrite)event).forward(target);
        }
    }

    @Override
    public IForward.ForwardParameter where(String param) {
        return this.parameters.where(param, new IForward.ForwardParameter(this, this.location.getParameter(param)));
    }

    @Override
    public IForward.ForwardParameter where(String param, Binding binding) {
        return (IForward.ForwardParameter)this.where(param).bindsTo(binding);
    }

    public String toString() {
        return this.location.toString();
    }

    @Override
    public ParameterizedPattern getTargetExpression() {
        return this.location;
    }
}

