/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class HttpInboundRewriteImpl
extends BaseRewrite<HttpServletRequest, HttpServletResponse>
implements HttpInboundServletRewrite {
    Logger log = Logger.getLogger(HttpInboundRewriteImpl.class);

    public HttpInboundRewriteImpl(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    @Override
    public void redirectTemporary(String location) {
        this.log.debug("Temporary Redirect (302) requested: [" + location + "]");
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot issue redirect.");
        }
        this.dispatchResource = this.encodeRedirectUrl(response, location);
        this.flow = BaseRewrite.Flow.REDIRECT_TEMPORARY;
    }

    @Override
    public void redirectPermanent(String location) {
        this.log.debug("Permanent Redirect (301) requested: [" + location + "]");
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot issue redirect.");
        }
        this.dispatchResource = this.encodeRedirectUrl(response, location);
        this.flow = BaseRewrite.Flow.REDIRECT_PERMANENT;
    }

    private String encodeRedirectUrl(HttpServletResponse response, String url) {
        try {
            URLBuilder builder = URLBuilder.createFrom(url);
            String path = builder.decode().toPath();
            return response.encodeRedirectURL(path + builder.getQueryStringBuilder().encode().toQueryString());
        }
        catch (Exception e) {
            this.log.warn("Failed to encode URL [" + url + "]", e);
            return response.encodeRedirectURL(url);
        }
    }

    @Override
    public void sendStatusCode(int code) {
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot send codes.");
        }
        try {
            response.setStatus(code);
            response.flushBuffer();
            this.abort();
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP status code.", e);
        }
    }

    @Override
    public void sendStatusCode(int code, String message) {
        try {
            ((HttpServletResponse)this.getResponse()).getWriter().write("<h1>" + message + "</h1>");
            this.sendStatusCode(code);
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP status code.", e);
        }
    }

    @Override
    public void sendErrorCode(int code) {
        this.sendErrorCode(code, null);
    }

    @Override
    public void sendErrorCode(int code, String message) {
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot send codes.");
        }
        try {
            if (message == null) {
                response.setStatus(code);
                response.flushBuffer();
            } else {
                response.sendError(code, message);
            }
            this.abort();
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP error code.", e);
        }
    }

    @Override
    public String getContextPath() {
        String contextPath = ((HttpServletRequest)this.getRequest()).getContextPath();
        return contextPath;
    }

    @Override
    public String getRequestPath() {
        String url = ((HttpServletRequest)this.getRequest()).getRequestURI();
        if (url.startsWith(this.getContextPath())) {
            url = url.substring(this.getContextPath().length());
        }
        url = URLBuilder.createFrom(url).decode().toURL();
        return url;
    }

    @Override
    public String getRequestQueryStringSeparator() {
        String queryString = this.getRequestQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            return "?";
        }
        return "";
    }

    @Override
    public String getRequestQueryString() {
        return ((HttpServletRequest)this.getRequest()).getQueryString() == null ? "" : QueryStringBuilder.createFrom(((HttpServletRequest)this.getRequest()).getQueryString()).decode().toQueryString().substring(1);
    }

    @Override
    public String getURL() {
        return this.getRequestPath() + this.getRequestQueryStringSeparator() + this.getRequestQueryString();
    }

    @Override
    public String toString() {
        return "InboundRewrite [" + ((HttpServletRequest)this.getRequest()).getMethod() + " url=" + this.getURL() + ", flow=" + (Object)((Object)this.getFlow()) + ", dispatchResource=" + this.getDispatchResource() + "]";
    }
}

