/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public abstract class DefaultOperationBuilder
implements OperationBuilder {
    public static OperationBuilder create() {
        return new NoOp();
    }

    public static OperationBuilder wrap(Operation operation) {
        if (operation == null) {
            return DefaultOperationBuilder.create();
        }
        return new DefaultCompositeOperation(DefaultOperationBuilder.create(), operation);
    }

    @Override
    public OperationBuilder and(Operation other) {
        if (other == null) {
            return this;
        }
        return new DefaultCompositeOperation(this, other);
    }

    private static class DefaultCompositeOperation
    extends DefaultOperationBuilder
    implements CompositeOperation {
        private final Operation left;
        private final Operation right;

        public DefaultCompositeOperation(Operation left, Operation right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            this.left.perform(event, context);
            this.right.perform(event, context);
        }

        @Override
        public List<Operation> getOperations() {
            return Arrays.asList(this.left, this.right);
        }

        public String toString() {
            return DefaultCompositeOperation.class.getSimpleName() + " [left=" + this.left + ", right=" + this.right + "]";
        }
    }

    public static class NoOp
    extends DefaultOperationBuilder {
        @Override
        public void perform(Rewrite event, EvaluationContext context) {
        }

        public String toString() {
            return "NoOp";
        }
    }
}

