/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.DefaultConditionBuilder;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.RelocatableRule;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.True;
import org.ocpsoft.rewrite.config.Visitor;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class RuleBuilder
implements RelocatableRule {
    private Integer priority = null;
    private String id = "";
    private Condition condition = new True();
    private Operation operation;

    protected RuleBuilder() {
    }

    public static RuleBuilder define() {
        return new RuleBuilder();
    }

    public static RuleBuilder wrap(Rule rule) {
        return new RuleBuilder().withId(rule.getId()).when(rule).perform(rule);
    }

    public static RuleBuilder define(String id) {
        return RuleBuilder.define().withId(id);
    }

    public RuleBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RuleBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public RuleBuilder when(Condition condition) {
        this.condition = DefaultConditionBuilder.wrap(this.condition).and(condition);
        return this;
    }

    public RuleBuilder perform(Operation operation) {
        this.operation = DefaultOperationBuilder.wrap(this.operation).and(operation);
        return this;
    }

    @Override
    public boolean evaluate(Rewrite event, EvaluationContext context) {
        return this.condition == null || this.condition.evaluate(event, context);
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        if (this.operation != null) {
            this.operation.perform(event, context);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int priority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Override
    public boolean isRelocated() {
        return this.priority != null;
    }

    public DefaultConditionBuilder getConditionBuilder() {
        if (this.condition == null) {
            this.condition = DefaultConditionBuilder.create();
        } else if (!(this.condition instanceof DefaultConditionBuilder)) {
            this.condition = DefaultConditionBuilder.wrap(this.condition);
        }
        return (DefaultConditionBuilder)this.condition;
    }

    public DefaultOperationBuilder getOperationBuilder() {
        if (this.operation == null) {
            this.operation = DefaultOperationBuilder.create();
        } else if (!(this.operation instanceof DefaultOperationBuilder)) {
            this.operation = DefaultOperationBuilder.wrap(this.operation);
        }
        return (DefaultOperationBuilder)this.operation;
    }

    public void accept(Visitor<Condition> visitor) {
        new ConditionVisit(this.condition).accept(visitor);
    }

    public String toString() {
        return "RuleBuilder [priority=" + this.priority + ", id=" + this.id + ", condition=" + this.condition + ", operation=" + this.operation + "]";
    }
}

