/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.servlet.util.Metadata;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;

public class URLBuilder {
    private Metadata metadata = new Metadata();
    private final List<String> segments = new ArrayList<String>();
    private QueryStringBuilder query = QueryStringBuilder.createNew();

    public static URLBuilder createNew() {
        return new URLBuilder();
    }

    public static URLBuilder createFrom(List<String> segments, Metadata metadata, QueryStringBuilder query) {
        return URLBuilder.createNew().appendPathSegments(segments).setMetadata(metadata).setQueryString(query);
    }

    public static URLBuilder createFrom(List<String> segments, Metadata metadata) {
        return URLBuilder.createNew().appendPathSegments(segments).setMetadata(metadata);
    }

    public static URLBuilder createFrom(String segments) {
        if (segments == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        if (segments.contains("?")) {
            String[] parts = segments.split("\\?", -1);
            String path = parts[0];
            String query = parts[1];
            if (parts.length > 2) {
                query = Strings.join(Arrays.asList(Arrays.copyOfRange(parts, 1, parts.length)), "?");
            }
            return new URLBuilder().appendPathSegments(path).addQueryParameters(query);
        }
        return new URLBuilder().appendPathSegments(segments);
    }

    private URLBuilder() {
    }

    private URLBuilder(List<String> segments, Metadata metadata, QueryStringBuilder query) {
        this.segments.addAll(segments);
        this.metadata = metadata.copy();
        this.query = query;
    }

    public URLBuilder appendPathSegments(List<String> segments) {
        this.segments.addAll(segments);
        return this;
    }

    public URLBuilder appendPathSegments(String segments) {
        if (segments != null) {
            String trimmedUrl;
            String temp = segments.trim();
            if (temp.startsWith("/") && this.segments.isEmpty()) {
                this.metadata.setLeadingSlash(true);
            }
            if (temp.endsWith("/")) {
                this.metadata.setTrailingSlash(true);
            }
            if (!(trimmedUrl = this.trimSurroundingSlashes(segments)).isEmpty() || "//".equals(segments)) {
                String[] newSegments = trimmedUrl.split("/", -1);
                this.segments.addAll(Arrays.asList(newSegments));
            }
        } else {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        return this;
    }

    public URLBuilder addQueryParameters(String parameters) {
        this.query.addParameters(parameters);
        return this;
    }

    public URLBuilder decode() {
        return new URLBuilder(this.getDecodedSegments(), this.metadata, this.query.decode());
    }

    private String decodeSegment(String segment) {
        try {
            String prepared = ("http://localhost/" + segment).replaceAll("\\+", "%20");
            URI uri = new URI(prepared);
            return uri.getPath().substring(1);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URLBuilder encode() {
        return new URLBuilder(this.getEncodedSegments(), this.metadata, this.query.encode());
    }

    private String encodeSegment(String segment) {
        try {
            URI uri = new URI("http", "localhost", "/" + segment, null);
            return uri.toASCIIString().substring(17);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private List<String> getDecodedSegments() {
        ArrayList<String> result = new ArrayList<String>();
        for (String segment : this.segments) {
            result.add(this.decodeSegment(segment));
        }
        return result;
    }

    private List<String> getEncodedSegments() {
        ArrayList<String> resultSegments = new ArrayList<String>();
        for (String segment : this.segments) {
            resultSegments.add(this.encodeSegment(segment));
        }
        return resultSegments;
    }

    public String getEncoding() {
        return this.metadata.getEncoding();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public QueryStringBuilder getQueryStringBuilder() {
        return this.query;
    }

    public URLBuilder setQueryString(QueryStringBuilder query) {
        this.query = query;
        return this;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public boolean hasLeadingSlash() {
        return this.metadata.hasLeadingSlash();
    }

    public boolean hasTrailingSlash() {
        return this.metadata.hasTrailingSlash();
    }

    public int numSegments() {
        return this.segments.size();
    }

    public void setEncoding(String encoding) {
        this.metadata.setEncoding(encoding);
    }

    public URLBuilder setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public String toPath() {
        return this.metadata.buildURLFromSegments(this.segments);
    }

    public String toString() {
        return this.toURL();
    }

    public URI toURI() {
        try {
            URI uri = new URI(this.toURL());
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("URL cannot be parsed.", e);
        }
    }

    public String toURL() {
        return this.toPath() + this.query.toQueryString();
    }

    private String trimSurroundingSlashes(String url) {
        String result = null;
        if (url != null) {
            result = url.trim();
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }
}

